/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.field.type.BaseDDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.template.soy.utils.SoyRawData;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"templatePath=/META-INF/resources/form.soy"})
public class DDMFormRendererImpl
implements DDMFormRenderer {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private JSONFactory _jsonFactory;
    private final List<TemplateResource> _templateResources = new CopyOnWriteArrayList<TemplateResource>();

    public String render(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmfre) {
            throw ddmfre;
        }
        catch (PortalException pe) {
            throw new DDMFormRenderingException((Throwable)pe);
        }
    }

    public String render(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmfre) {
            throw ddmfre;
        }
        catch (PortalException pe) {
            throw new DDMFormRenderingException((Throwable)pe);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        String templatePath = MapUtil.getString(properties, (String)"templatePath");
        TemplateResource formTemplateResource = this.getFormTemplateResource(templatePath);
        this._templateResources.add(formTemplateResource);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMFormFieldRenderer(DDMFormFieldRenderer ddmFormFieldRenderer) {
        TemplateResource templateResource = this.getTemplateResource(ddmFormFieldRenderer);
        if (templateResource != null) {
            this._templateResources.add(templateResource);
        }
    }

    protected String doRender(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        Template template = TemplateManagerUtil.getTemplate((String)"soy", this._templateResources, (boolean)false);
        this.populateCommonContext(template, ddmForm, ddmFormLayout, ddmFormRenderingContext);
        SoyRawData soyRawData = (SoyRawData)template.get("templateNamespace");
        String templateNamespace = (String)soyRawData.getValue();
        String html = this.render(template, templateNamespace);
        String javaScript = this.render(template, "ddm.form_renderer_js");
        return html.concat(javaScript);
    }

    protected TemplateResource getFormTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected TemplateResource getTemplateResource(DDMFormFieldRenderer ddmFormFieldRenderer) {
        if (ddmFormFieldRenderer instanceof BaseDDMFormFieldRenderer) {
            BaseDDMFormFieldRenderer baseDDMFormFieldRenderer = (BaseDDMFormFieldRenderer)ddmFormFieldRenderer;
            return baseDDMFormFieldRenderer.getTemplateResource();
        }
        return null;
    }

    protected TemplateResource getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected void populateCommonContext(Template template, DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        Map ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        for (final Map.Entry entry : ddmFormTemplateContext.entrySet()) {
            SoyRawData soyRawData = new SoyRawData(){

                public Object getValue() {
                    return entry.getValue();
                }
            };
            template.put(entry.getKey(), (Object)soyRawData);
        }
        ddmFormTemplateContext.remove("fieldTypes");
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        template.put((Object)"context", (Object)jsonSerializer.serializeDeep((Object)ddmFormTemplateContext));
    }

    protected void removeDDMFormFieldRenderer(DDMFormFieldRenderer ddmFormFieldRenderer) {
        TemplateResource templateResource = this.getTemplateResource(ddmFormFieldRenderer);
        if (templateResource != null) {
            this._templateResources.remove(templateResource);
        }
    }

    protected String render(Template template, String namespace) throws TemplateException {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.put((Object)"namespace", (Object)namespace);
        template.put((Object)"render_strict", (Object)Boolean.FALSE);
        template.processTemplate((Writer)writer);
        return writer.toString();
    }
}

