/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.helper;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandler;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyResponse;
import com.liferay.dynamic.data.mapping.expression.UpdateFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateResponse;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorFieldContextKey;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionActionHandler;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionObserver;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.helper.DDMFormEvaluatorFormValuesHelper;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.helper.DDMFormEvaluatorRuleHelper;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueEditingAware;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueLocalizer;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.form.page.change.DDMFormPageChange;
import com.liferay.dynamic.data.mapping.form.page.change.DDMFormPageChangeRegistry;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.util.NumericDDMFormFieldUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DDMFormEvaluatorHelper {
    protected final DDMFormEvaluatorExpressionFieldAccessor ddmFormEvaluatorDDMExpressionFieldAccessor;
    protected DDMFormEvaluatorExpressionActionHandler ddmFormEvaluatorExpressionActionHandler;
    protected final DDMFormEvaluatorExpressionObserver ddmFormEvaluatorExpressionObserver;
    protected final DDMFormEvaluatorExpressionParameterAccessor ddmFormEvaluatorExpressionParameterAccessor;
    protected final DDMFormFieldValueAccessor<String> defaultDDMFormFieldValueAccessor = new DefaultDDMFormFieldValueAccessor();
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEvaluatorHelper.class);
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DDMForm _ddmForm;
    private final DDMFormEvaluatorEvaluateRequest _ddmFormEvaluatorEvaluateRequest;
    private final DDMFormEvaluatorFormValuesHelper _ddmFormEvaluatorFormValuesHelper;
    private final DDMFormEvaluatorRuleHelper _ddmFormEvaluatorRuleHelper;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final Map<DDMFormEvaluatorFieldContextKey, Map<String, Object>> _ddmFormFieldsPropertyChanges = new HashMap<DDMFormEvaluatorFieldContextKey, Map<String, Object>>();
    private final DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    private final DDMFormLayout _ddmFormLayout;
    private final DDMFormPageChangeRegistry _ddmFormPageChangeRegistry;
    private List<String> _evaluatedActions;
    private final Map<Integer, Integer> _pageFlow = new HashMap<Integer, Integer>();

    public DDMFormEvaluatorHelper(DDMExpressionFactory ddmExpressionFactory, DDMFormEvaluatorEvaluateRequest ddmFormEvaluatorEvaluateRequest, DDMFormFieldTypeServicesRegistry ddmFormFieldTypeServicesRegistry, DDMFormPageChangeRegistry ddmFormPageChangeRegistry) {
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._ddmFormEvaluatorEvaluateRequest = ddmFormEvaluatorEvaluateRequest;
        this._ddmFormFieldTypeServicesRegistry = ddmFormFieldTypeServicesRegistry;
        this._ddmFormPageChangeRegistry = ddmFormPageChangeRegistry;
        this._ddmForm = ddmFormEvaluatorEvaluateRequest.getDDMForm();
        this._ddmFormEvaluatorFormValuesHelper = new DDMFormEvaluatorFormValuesHelper(this._ddmFormEvaluatorEvaluateRequest.getDDMFormValues());
        this.ddmFormEvaluatorExpressionObserver = new DDMFormEvaluatorExpressionObserver(this._ddmFormEvaluatorFormValuesHelper, this._ddmFormFieldsPropertyChanges);
        this._ddmFormFieldsMap = this._ddmForm.getDDMFormFieldsMap(true);
        this._ddmFormLayout = ddmFormEvaluatorEvaluateRequest.getDDMFormLayout();
        this._ddmFormEvaluatorRuleHelper = new DDMFormEvaluatorRuleHelper(this._ddmFormFieldsMap, this.ddmFormEvaluatorExpressionObserver);
        this.ddmFormEvaluatorDDMExpressionFieldAccessor = new DDMFormEvaluatorExpressionFieldAccessor(this._ddmFormEvaluatorFormValuesHelper, this._ddmFormFieldsMap, this._ddmFormFieldsPropertyChanges, this._ddmFormFieldTypeServicesRegistry, ddmFormEvaluatorEvaluateRequest.getLocale());
        this.ddmFormEvaluatorExpressionActionHandler = new DDMFormEvaluatorExpressionActionHandler(this._pageFlow);
        this.ddmFormEvaluatorExpressionParameterAccessor = new DDMFormEvaluatorExpressionParameterAccessor(this._ddmFormEvaluatorEvaluateRequest);
    }

    public DDMFormEvaluatorEvaluateResponse evaluate() {
        this._evaluateDDMFormPageChange();
        this._evaluateVisibilityExpressions();
        List ddmFormRules = null;
        ddmFormRules = this._ddmFormLayout != null && ListUtil.isNotEmpty((List)this._ddmFormLayout.getDDMFormRules()) ? this._ddmFormLayout.getDDMFormRules() : this._ddmForm.getDDMFormRules();
        this._evaluateDDMFormRules(ddmFormRules, false);
        this._evaluateDDMFormRules(ddmFormRules, true);
        this._validateFields();
        this._localizeNumericDDMFormFieldValues();
        return this._buildDDMFormEvaluatorEvaluateResponse();
    }

    protected Map<DDMFormEvaluatorFieldContextKey, Map<String, Object>> getDDMFormFieldsPropertyChanges() {
        return this._ddmFormFieldsPropertyChanges;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        DDMFormFieldValue ddmFormFieldValue = this._ddmFormEvaluatorFormValuesHelper.getDDMFormFieldValue(ddmFormEvaluatorFieldContextKey);
        if (ddmFormFieldValue == null) {
            return null;
        }
        Object value = this.ddmFormEvaluatorDDMExpressionFieldAccessor.getFieldPropertyChanged(ddmFormEvaluatorFieldContextKey, "value");
        if (value != null) {
            this._updateDDMFormFieldValue(ddmFormFieldValue, value);
        }
        return ddmFormFieldValue;
    }

    protected DDMFormFieldValueAccessor<?> getDDMFormFieldValueAccessor(String type) {
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldValueAccessor(type);
        if (ddmFormFieldValueAccessor != null) {
            return ddmFormFieldValueAccessor;
        }
        return this.defaultDDMFormFieldValueAccessor;
    }

    protected Set<Integer> getDisabledPagesIndexes() {
        HashSet<Integer> disabledPagesIndexes = new HashSet<Integer>();
        for (Map.Entry<Integer, Integer> entry : this._pageFlow.entrySet()) {
            int fromPageIndex = entry.getKey();
            int toPageIndex = entry.getValue();
            for (int i = fromPageIndex + 1; i < toPageIndex; ++i) {
                disabledPagesIndexes.add(i);
            }
        }
        return disabledPagesIndexes;
    }

    private DDMFormEvaluatorEvaluateResponse _buildDDMFormEvaluatorEvaluateResponse() {
        DDMFormEvaluatorEvaluateResponse.Builder formEvaluatorEvaluateResponse = DDMFormEvaluatorEvaluateResponse.Builder.newBuilder(this.getDDMFormFieldsPropertyChanges());
        formEvaluatorEvaluateResponse.withDisabledPagesIndexes(this.getDisabledPagesIndexes());
        return formEvaluatorEvaluateResponse.build();
    }

    private <T> DDMExpression<T> _createExpression(String expression) throws DDMExpressionException {
        return this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)expression).withDDMExpressionActionHandler((DDMExpressionActionHandler)this.ddmFormEvaluatorExpressionActionHandler).withDDMExpressionFieldAccessor((DDMExpressionFieldAccessor)this.ddmFormEvaluatorDDMExpressionFieldAccessor).withDDMExpressionObserver((DDMExpressionObserver)this.ddmFormEvaluatorExpressionObserver).withDDMExpressionParameterAccessor((DDMExpressionParameterAccessor)this.ddmFormEvaluatorExpressionParameterAccessor).build());
    }

    private void _evaluateDDMFormPageChange() {
        if (this._ddmFormLayout == null || this._ddmFormLayout.getNextPage() == this._ddmFormLayout.getPreviousPage()) {
            return;
        }
        DDMFormPageChange ddmFormPageChange = this._ddmFormPageChangeRegistry.getDDMFormPageChangeByDDMFormInstanceId(String.valueOf(this._ddmFormEvaluatorEvaluateRequest.getDDMFormInstanceId()));
        if (ddmFormPageChange == null) {
            return;
        }
        DDMFormEvaluatorEvaluateResponse ddmFormEvaluatorEvaluateResponse = ddmFormPageChange.evaluate(this._ddmFormEvaluatorEvaluateRequest);
        this._ddmFormFieldsPropertyChanges.putAll(ddmFormEvaluatorEvaluateResponse.getDDMFormFieldsPropertyChanges());
    }

    private void _evaluateDDMFormRule(DDMFormRule ddmFormRule, boolean ddmFormRuleConditionEvaluationResult) {
        if (ddmFormRuleConditionEvaluationResult) {
            List actions = ddmFormRule.getActions();
            Stream stream = actions.stream();
            this._evaluateDDMFormRuleAction(stream.collect(Collectors.joining(" AND ")));
            this._evaluatedActions = ListUtil.copy((List)actions);
        } else {
            DDMFormRule copyDDMFormRule = new DDMFormRule(ddmFormRule);
            if (this._evaluatedActions != null) {
                List actions = copyDDMFormRule.getActions();
                Stream stream = actions.stream();
                List unevaluatedActions = stream.filter(action -> !this._evaluatedActions.contains(action)).collect(Collectors.toList());
                copyDDMFormRule.setActions(unevaluatedActions);
            }
            this._ddmFormEvaluatorRuleHelper.checkFieldAffectedByAction(copyDDMFormRule);
        }
    }

    private void _evaluateDDMFormRuleAction(String action) {
        block2: {
            try {
                this._evaluateExpression(action);
            }
            catch (DDMExpressionException ddmExpressionException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)ddmExpressionException);
            }
        }
    }

    private Boolean _evaluateDDMFormRuleCondition(String condition) {
        try {
            return (Boolean)this._evaluateExpression(condition);
        }
        catch (DDMExpressionException ddmExpressionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ddmExpressionException);
            }
            return false;
        }
    }

    private void _evaluateDDMFormRules(List<DDMFormRule> ddmFormRules, Boolean ddmFormRuleConditionEvaluationResult) {
        Stream stream = ddmFormRules.stream();
        stream.filter(DDMFormRule::isEnabled).filter(ddmFormRule -> Validator.isNotNull((String)ddmFormRule.getCondition()) && Objects.equals(ddmFormRuleConditionEvaluationResult, this._evaluateDDMFormRuleCondition(ddmFormRule.getCondition()))).forEach(ddmFormRule -> {
            this._evaluateDDMFormRule((DDMFormRule)ddmFormRule, ddmFormRuleConditionEvaluationResult);
            this._resetInvisibleFieldValue();
        });
    }

    private <T> T _evaluateExpression(String expression) throws DDMExpressionException {
        DDMExpression<T> ddmExpression = this._createExpression(expression);
        return (T)ddmExpression.evaluate();
    }

    private void _evaluateVisibilityExpression(Map.Entry<String, String> entry) {
        block2: {
            try {
                UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)entry.getKey(), (String)"visible", this._evaluateExpression(entry.getValue()));
                this.ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
            }
            catch (DDMExpressionException ddmExpressionException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)ddmExpressionException);
            }
        }
    }

    private void _evaluateVisibilityExpressions() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> ddmFormFieldsStream = ddmFormFields.stream();
        Map<String, String> nameVisibilityExpressionMap = ddmFormFieldsStream.filter(field -> Validator.isNotNull((String)field.getVisibilityExpression())).collect(Collectors.toMap(field -> field.getName(), field -> field.getVisibilityExpression()));
        this._forEachEntry(nameVisibilityExpressionMap, this::_evaluateVisibilityExpression);
    }

    private boolean _filterFieldsWithDDMFormFieldValidation(DDMFormField ddmFormField) {
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation == null) {
            return false;
        }
        return Validator.isNotNull((Object)ddmFormFieldValidation.getDDMFormFieldValidationExpression());
    }

    private boolean _filterVisibleFieldsMarkedAsRequired(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        if (!this._isBooleanPropertyValue(ddmFormFieldContextKey, "required", false)) {
            return false;
        }
        return this._isBooleanPropertyValue(ddmFormFieldContextKey, "visible", true);
    }

    private boolean _filterVisibleFieldsWithInputMask(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        if (!this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "inputMask", false)) {
            return false;
        }
        return this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "visible", true);
    }

    private <K, V> void _forEachEntry(Map<K, V> map, Consumer<Map.Entry<K, V>> entryConsumer) {
        Set<Map.Entry<K, V>> set = map.entrySet();
        Stream stream = set.stream();
        stream.forEach(entryConsumer);
    }

    private Stream<DDMFormEvaluatorFieldContextKey> _getDDMFormEvaluatorFieldContextKeysStream(String name) {
        Set<DDMFormEvaluatorFieldContextKey> ddmFormFieldContextKeys = this._ddmFormEvaluatorFormValuesHelper.getDDMFormFieldContextKeys(name);
        return ddmFormFieldContextKeys.stream();
    }

    private DDMFormFieldValidation _getDDMFormFieldValidation(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormEvaluatorFieldContextKey.getName());
        return ddmFormField.getDDMFormFieldValidation();
    }

    private Object _getFieldPropertyResponseValue(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey, String propertyName) {
        String fieldName = ddmFormEvaluatorFieldContextKey.getName();
        String instanceId = ddmFormEvaluatorFieldContextKey.getInstanceId();
        GetFieldPropertyRequest.Builder builder = GetFieldPropertyRequest.Builder.newBuilder((String)fieldName, (String)propertyName);
        builder.withInstanceId(instanceId);
        GetFieldPropertyResponse getFieldPropertyResponse = this.ddmFormEvaluatorDDMExpressionFieldAccessor.getFieldProperty(builder.build());
        return getFieldPropertyResponse.getValue();
    }

    private boolean _isBooleanPropertyValue(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey, String booleanPropertyName, boolean defaultValue) {
        Map changedProperties = this._ddmFormFieldsPropertyChanges.getOrDefault(ddmFormFieldContextKey, Collections.emptyMap());
        if (changedProperties.containsKey(booleanPropertyName)) {
            return MapUtil.getBoolean(changedProperties, (String)booleanPropertyName);
        }
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldContextKey.getName());
        return GetterUtil.getBoolean((Object)ddmFormField.getProperty(booleanPropertyName), (boolean)defaultValue);
    }

    private boolean _isConfirmationValueInvalid(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        DDMFormField ddmFormField;
        DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(ddmFormEvaluatorFieldContextKey);
        if (ddmFormFieldValue == null) {
            return false;
        }
        String confirmationValue = Objects.toString(ddmFormFieldValue.getConfirmationValue(), "");
        String valueString = "";
        Value value = ddmFormFieldValue.getValue();
        if (value != null) {
            valueString = value.getString(this._ddmFormEvaluatorEvaluateRequest.getLocale());
        }
        if (Objects.equals((ddmFormField = this._ddmFormFieldsMap.get(ddmFormEvaluatorFieldContextKey.getName())).getDataType(), "double") && Objects.equals(ddmFormField.getType(), "numeric")) {
            confirmationValue = NumericDDMFormFieldUtil.getFormattedValue((Locale)this._ddmFormEvaluatorEvaluateRequest.getLocale(), (String)confirmationValue);
            valueString = NumericDDMFormFieldUtil.getFormattedValue((Locale)this._ddmFormEvaluatorEvaluateRequest.getLocale(), (String)valueString);
        }
        return !Objects.equals(confirmationValue, valueString);
    }

    private boolean _isFieldEmpty(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(ddmFormEvaluatorFieldContextKey);
        if (ddmFormFieldValue == null) {
            return true;
        }
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormEvaluatorFieldContextKey.getName());
        DDMFormFieldValueAccessor<?> ddmFormFieldValueAccessor = this.getDDMFormFieldValueAccessor(ddmFormField.getType());
        return ddmFormFieldValueAccessor.isEmpty(ddmFormFieldValue, this._ddmFormEvaluatorEvaluateRequest.getLocale());
    }

    private boolean _isFieldNative(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        return this._isBooleanPropertyValue(ddmFormFieldContextKey, "nativeField", true);
    }

    private boolean _isFieldReadOnly(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        return this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "readOnly", false);
    }

    private boolean _isFieldVisible(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        Map<String, Object> ddmFormFieldPropertyChanges = this._ddmFormFieldsPropertyChanges.get(ddmFormFieldContextKey);
        if (ddmFormFieldPropertyChanges == null) {
            return true;
        }
        return GetterUtil.get((Object)ddmFormFieldPropertyChanges.get("visible"), (boolean)true);
    }

    private boolean _isFieldWithConfirmationFieldAndVisible(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        if (!this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "requireConfirmation", false)) {
            return false;
        }
        return this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "visible", true);
    }

    private boolean _isHideField(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        return this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "hideField", false);
    }

    private boolean _isIntegerNumericField(DDMFormField ddmFormField) {
        return Objects.equals(ddmFormField.getDataType(), "integer") && Objects.equals(ddmFormField.getType(), "numeric");
    }

    private boolean _isNumericField(DDMFormField ddmFormField) {
        return Objects.equals(ddmFormField.getType(), "numeric");
    }

    private boolean _isObjectRelationshipFieldInvalid(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        if (!this._isBooleanPropertyValue(ddmFormEvaluatorFieldContextKey, "visible", true)) {
            return false;
        }
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormEvaluatorFieldContextKey.getName());
        Object value = ddmFormField.getProperty("value");
        return !(value instanceof String);
    }

    private boolean _isValueWithInputMaskInvalid(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey) {
        DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(ddmFormEvaluatorFieldContextKey);
        if (ddmFormFieldValue == null) {
            return false;
        }
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return false;
        }
        String valueString = value.getString(this._ddmFormEvaluatorEvaluateRequest.getLocale());
        if (Validator.isNull((String)valueString)) {
            return false;
        }
        LocalizedValue localizedValue = (LocalizedValue)this._getFieldPropertyResponseValue(ddmFormEvaluatorFieldContextKey, "inputMaskFormat");
        if (localizedValue == null) {
            return false;
        }
        String inputMaskFormat = localizedValue.getString(this._ddmFormEvaluatorEvaluateRequest.getLocale());
        return valueString.length() < StringUtil.count((String)inputMaskFormat, (String)"9");
    }

    private void _localizeDDMFormFieldValue(DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey) {
        DDMFormFieldValue ddmFormFieldValue = this._ddmFormEvaluatorFormValuesHelper.getDDMFormFieldValue(ddmFormFieldContextKey);
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return;
        }
        this._forEachEntry(value.getValues(), entry -> {
            DDMFormFieldValueLocalizer ddmFormFieldValueLocalizer;
            if (Validator.isNotNull((String)((String)entry.getValue())) && (ddmFormFieldValueLocalizer = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldValueLocalizer(ddmFormFieldValue.getType())) != null) {
                if (ddmFormFieldValueLocalizer instanceof DDMFormFieldValueEditingAware) {
                    DDMFormFieldValueEditingAware ddmFormFieldValueEditingAware = (DDMFormFieldValueEditingAware)ddmFormFieldValueLocalizer;
                    ddmFormFieldValueEditingAware.setEditingFieldValue(this._ddmFormEvaluatorEvaluateRequest.isEditingFieldValue());
                }
                value.addString((Locale)entry.getKey(), ddmFormFieldValueLocalizer.localize((String)entry.getValue(), (Locale)entry.getKey()));
            }
        });
    }

    private void _localizeNumericDDMFormFieldValues() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> stream = ddmFormFields.stream();
        stream.filter(this::_isNumericField).flatMap(ddmFormField -> this._getDDMFormEvaluatorFieldContextKeysStream(ddmFormField.getName())).forEach(this::_localizeDDMFormFieldValue);
    }

    private void _resetInvisibleFieldValue() {
        this._ddmFormFieldsPropertyChanges.forEach((ddmFormFieldContextKey, ddmFormFieldProperties) -> {
            if (this._ddmFormEvaluatorEvaluateRequest.isViewMode() && this._ddmFormEvaluatorEvaluateRequest.isEditingFieldValue() && !this._isFieldNative((DDMFormEvaluatorFieldContextKey)ddmFormFieldContextKey) && !this._isFieldVisible((DDMFormEvaluatorFieldContextKey)ddmFormFieldContextKey)) {
                ddmFormFieldProperties.put("value", "");
            }
        });
    }

    private void _setFieldAsInvalid(DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey, String errorMessage) {
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormEvaluatorFieldContextKey.getName(), (String)"errorMessage", (Object)errorMessage);
        builder.withInstanceId(ddmFormEvaluatorFieldContextKey.getInstanceId()).withParameter("valid", (Object)false);
        this.ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
    }

    private void _updateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Object newValue) {
        DDMForm ddmForm;
        Set availableLocales;
        Value value = ddmFormFieldValue.getValue();
        Locale locale = value.getDefaultLocale();
        if (value.isLocalized() && (availableLocales = (ddmForm = this._ddmFormEvaluatorEvaluateRequest.getDDMForm()).getAvailableLocales()).contains(this._ddmFormEvaluatorEvaluateRequest.getLocale())) {
            locale = this._ddmFormEvaluatorEvaluateRequest.getLocale();
        }
        value.addString(locale, String.valueOf(newValue));
    }

    private void _validateFields() {
        this._validateFieldsMarkedAsRequired();
        this._validateFieldsWithConfirmationField();
        this._validateFieldsWithDDMFormFieldValidation();
        this._validateNumericFieldsWithInputMask();
        this._validateObjectRelationshipFields();
    }

    private void _validateFieldsMarkedAsRequired() {
        Set<Map.Entry<String, DDMFormField>> entrySet = this._ddmFormFieldsMap.entrySet();
        Stream stream = entrySet.stream();
        stream.flatMap(entry -> this._getDDMFormEvaluatorFieldContextKeysStream((String)entry.getKey())).filter(this::_filterVisibleFieldsMarkedAsRequired).filter(this::_isFieldEmpty).forEach(ddmFormEvaluatorFieldContextKey -> {
            Map values;
            String value;
            String requiredErrorMessage = LanguageUtil.get((Locale)this._ddmFormEvaluatorEvaluateRequest.getLocale(), (String)"this-field-is-required");
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormEvaluatorFieldContextKey.getName());
            LocalizedValue localizedValue = ddmFormField.getRequiredErrorMessage();
            if (localizedValue != null && Validator.isNotNull((String)(value = (String)(values = localizedValue.getValues()).get(this._ddmFormEvaluatorEvaluateRequest.getLocale())))) {
                requiredErrorMessage = value;
            }
            this._setFieldAsInvalid((DDMFormEvaluatorFieldContextKey)ddmFormEvaluatorFieldContextKey, requiredErrorMessage);
        });
    }

    private void _validateFieldsWithConfirmationField() {
        Set<Map.Entry<String, DDMFormField>> entrySet = this._ddmFormFieldsMap.entrySet();
        Stream stream = entrySet.stream();
        stream.flatMap(entry -> this._getDDMFormEvaluatorFieldContextKeysStream((String)entry.getKey())).filter(this::_isFieldWithConfirmationFieldAndVisible).filter(this::_isConfirmationValueInvalid).forEach(ddmFormEvaluatorFieldContextKey -> this._setFieldAsInvalid((DDMFormEvaluatorFieldContextKey)ddmFormEvaluatorFieldContextKey, ""));
    }

    private void _validateFieldsWithDDMFormFieldValidation() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> ddmFormFieldsStream = ddmFormFields.stream();
        Map ddmFormFieldValidations = ddmFormFieldsStream.filter(this::_filterFieldsWithDDMFormFieldValidation).flatMap(ddmFormField -> this._getDDMFormEvaluatorFieldContextKeysStream(ddmFormField.getName())).collect(Collectors.toMap(Function.identity(), this::_getDDMFormFieldValidation));
        this._forEachEntry(ddmFormFieldValidations, this::_validateFieldWithDDMFormFieldValidation);
    }

    private void _validateFieldWithDDMFormFieldValidation(Map.Entry<DDMFormEvaluatorFieldContextKey, DDMFormFieldValidation> entry) {
        Boolean valid;
        String fieldInstanceId;
        String fieldName;
        DDMFormFieldValidation ddmFormFieldValidation;
        block10: {
            DDMFormEvaluatorFieldContextKey ddmFormEvaluatorFieldContextKey = entry.getKey();
            if (this._isConfirmationValueInvalid(ddmFormEvaluatorFieldContextKey) && this._isFieldWithConfirmationFieldAndVisible(ddmFormEvaluatorFieldContextKey) || this._isFieldEmpty(ddmFormEvaluatorFieldContextKey)) {
                return;
            }
            if (this._isFieldReadOnly(ddmFormEvaluatorFieldContextKey) || !this._isFieldVisible(ddmFormEvaluatorFieldContextKey) || this._isHideField(ddmFormEvaluatorFieldContextKey)) {
                return;
            }
            ddmFormFieldValidation = entry.getValue();
            if (ddmFormFieldValidation == null) {
                return;
            }
            DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
            if (Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) {
                return;
            }
            fieldName = ddmFormEvaluatorFieldContextKey.getName();
            fieldInstanceId = ddmFormEvaluatorFieldContextKey.getInstanceId();
            valid = Boolean.FALSE;
            try {
                String localizedValueString = null;
                LocalizedValue parameterLocalizedValue = ddmFormFieldValidation.getParameterLocalizedValue();
                if (parameterLocalizedValue != null && Validator.isNull((String)(localizedValueString = parameterLocalizedValue.getString(this._ddmFormEvaluatorEvaluateRequest.getLocale())))) {
                    localizedValueString = parameterLocalizedValue.getString(parameterLocalizedValue.getDefaultLocale());
                }
                DDMExpression ddmExpression = null;
                ddmExpression = Validator.isNull(localizedValueString) ? this._createExpression(ddmFormFieldValidationExpression.getValue()) : this._createExpression(ddmFormFieldValidationExpression.getExpression(this._ddmFormEvaluatorEvaluateRequest.getDDMFormValues(), localizedValueString, this.ddmFormEvaluatorExpressionParameterAccessor.getTimeZoneId()));
                ddmExpression.setVariable(fieldName, this._getFieldPropertyResponseValue(ddmFormEvaluatorFieldContextKey, "value"));
                valid = (Boolean)ddmExpression.evaluate();
            }
            catch (DDMExpressionException ddmExpressionException) {
                if (!_log.isDebugEnabled()) break block10;
                _log.debug((Throwable)ddmExpressionException);
            }
        }
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)fieldName, (String)"valid", (Object)valid);
        builder.withInstanceId(fieldInstanceId);
        if (!Objects.equals(Boolean.TRUE, valid)) {
            String errorMessage = null;
            LocalizedValue errorMessageLocalizedValue = ddmFormFieldValidation.getErrorMessageLocalizedValue();
            if (errorMessageLocalizedValue != null) {
                errorMessage = errorMessageLocalizedValue.getString(this._ddmFormEvaluatorEvaluateRequest.getLocale());
            }
            if (Validator.isNull(errorMessage)) {
                errorMessage = LanguageUtil.get((Locale)this._ddmFormEvaluatorEvaluateRequest.getLocale(), (String)"this-field-is-invalid");
            }
            builder.withParameter("errorMessage", (Object)errorMessage);
        }
        this.ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
    }

    private void _validateNumericFieldsWithInputMask() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> stream = ddmFormFields.stream();
        stream.filter(this::_isIntegerNumericField).flatMap(ddmFormField -> this._getDDMFormEvaluatorFieldContextKeysStream(ddmFormField.getName())).filter(this::_filterVisibleFieldsWithInputMask).filter(this::_isValueWithInputMaskInvalid).forEach(ddmFormEvaluatorFieldContextKey -> this._setFieldAsInvalid((DDMFormEvaluatorFieldContextKey)ddmFormEvaluatorFieldContextKey, LanguageUtil.get((Locale)this._ddmFormEvaluatorEvaluateRequest.getLocale(), (String)"input-format-is-not-satisfied")));
    }

    private void _validateObjectRelationshipFields() {
        Collection<DDMFormField> ddmFormFields = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> stream = ddmFormFields.stream();
        stream.filter(ddmFormField -> Objects.equals(ddmFormField.getType(), "object-relationship")).flatMap(ddmFormField -> this._getDDMFormEvaluatorFieldContextKeysStream(ddmFormField.getName())).filter(this::_isObjectRelationshipFieldInvalid).forEach(ddmFormEvaluatorFieldContextKey -> this._setFieldAsInvalid((DDMFormEvaluatorFieldContextKey)ddmFormEvaluatorFieldContextKey, LanguageUtil.get((Locale)this._ddmFormEvaluatorEvaluateRequest.getLocale(), (String)"the-field-value-is-invalid")));
    }
}

