/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.function;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserverAware;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessorAware;
import com.liferay.dynamic.data.mapping.expression.UpdateFieldPropertyRequest;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class SetOptionsFunction
implements DDMExpressionFunction.Function2<String, String, Boolean>,
DDMExpressionObserverAware,
DDMExpressionParameterAccessorAware {
    public static final String NAME = "setOptions";
    protected JSONFactory jsonFactory;
    private static final Log _log = LogFactoryUtil.getLog(SetOptionsFunction.class);
    private DDMExpressionObserver _ddmExpressionObserver;
    private DDMExpressionParameterAccessor _ddmExpressionParameterAccessor;

    public SetOptionsFunction(JSONFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public Boolean apply(String field, String json) {
        if (this._ddmExpressionObserver == null || this._ddmExpressionParameterAccessor == null) {
            return false;
        }
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)field, (String)"options", this.createKeyValuePairList(json, this._ddmExpressionParameterAccessor.getLocale()));
        this._ddmExpressionObserver.updateFieldProperty(builder.build());
        return true;
    }

    public String getName() {
        return NAME;
    }

    public void setDDMExpressionObserver(DDMExpressionObserver ddmExpressionObserver) {
        this._ddmExpressionObserver = ddmExpressionObserver;
    }

    public void setDDMExpressionParameterAccessor(DDMExpressionParameterAccessor ddmExpressionParameterAccessor) {
        this._ddmExpressionParameterAccessor = ddmExpressionParameterAccessor;
    }

    protected List<KeyValuePair> createKeyValuePairList(String value, Locale locale) {
        String languageId = LanguageUtil.getLanguageId((Locale)locale);
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        try {
            JSONObject jsonObject = this.jsonFactory.createJSONObject(String.valueOf(value));
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String currentLanguageId = (String)iterator.next();
                if (!currentLanguageId.equals(languageId)) continue;
                JSONArray jsonArray = jsonObject.getJSONArray(currentLanguageId);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject optionJSONObject = jsonArray.getJSONObject(i);
                    KeyValuePair keyValuePair = new KeyValuePair(optionJSONObject.getString("value"), optionJSONObject.getString("label"));
                    keyValuePairs.add(keyValuePair);
                }
                break;
            }
        }
        catch (JSONException jsonException) {
            _log.error((Object)jsonException, (Throwable)jsonException);
        }
        return keyValuePairs;
    }
}

