/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.function;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.stream.Stream;

public class AllFunction
implements DDMExpressionFunction.Function2<String, Object, Boolean> {
    public static final String NAME = "all";
    private static final Log _log = LogFactoryUtil.getLog(AllFunction.class);
    private final DDMExpressionFactory _ddmExpressionFactory;

    public AllFunction(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    public Boolean apply(String expression, Object parameter) {
        if (!expression.contains("#value#")) {
            return false;
        }
        Object[] values = null;
        if (this.isArray(parameter)) {
            values = (Object[])parameter;
            if (values.length == 0) {
                return false;
            }
        } else {
            values = new Object[]{parameter};
        }
        return Stream.of(values).allMatch(value -> this.accept(expression, value));
    }

    public String getName() {
        return NAME;
    }

    protected boolean accept(String expression, Object value) {
        expression = StringUtil.replace((String)expression, (String)"#value#", (String)String.valueOf(value));
        try {
            CreateExpressionRequest createExpressionRequest = CreateExpressionRequest.Builder.newBuilder((String)expression).build();
            DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(createExpressionRequest);
            return (Boolean)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmExpressionException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ddmExpressionException, (Throwable)ddmExpressionException);
            }
            return false;
        }
    }

    protected boolean isArray(Object parameter) {
        Class<?> clazz = parameter.getClass();
        return clazz.isArray();
    }
}

