/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.helper;

import com.liferay.dynamic.data.mapping.expression.UpdateFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.expression.DDMFormEvaluatorExpressionObserver;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class DDMFormEvaluatorRuleHelper {
    private final DDMFormEvaluatorExpressionObserver _ddmFormEvaluatorExpressionObserver;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;

    public DDMFormEvaluatorRuleHelper(Map<String, DDMFormField> ddmFormFieldsMap, DDMFormEvaluatorExpressionObserver ddmFormEvaluatorExpressionObserver) {
        this._ddmFormFieldsMap = ddmFormFieldsMap;
        this._ddmFormEvaluatorExpressionObserver = ddmFormEvaluatorExpressionObserver;
    }

    public void checkFieldAffectedByAction(DDMFormRule ddmFormRule) {
        Collection<DDMFormField> fieldNameSet = this._ddmFormFieldsMap.values();
        Stream<DDMFormField> stream = fieldNameSet.parallelStream();
        stream.forEach(field -> this.checkFieldAffectedByAction(ddmFormRule, (DDMFormField)field));
    }

    protected void checkFieldAffectedByAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        this.checkFieldAffectedBySetReadOnlyAction(ddmFormRule, ddmFormField);
        this.checkFieldAffectedBySetRequiredAction(ddmFormRule, ddmFormField);
        this.checkFieldAffectedBySetVisibleAction(ddmFormRule, ddmFormField);
    }

    protected void checkFieldAffectedBySetReadOnlyAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        if (this.containsAction(ddmFormRule, "setEnabled", ddmFormField.getName(), !ddmFormField.isReadOnly())) {
            UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormField.getName(), (String)"readOnly", (Object)(!ddmFormField.isReadOnly() ? 1 : 0));
            this._ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
        }
    }

    protected void checkFieldAffectedBySetRequiredAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        if (this.containsAction(ddmFormRule, "setRequired", ddmFormField.getName(), ddmFormField.isRequired())) {
            UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormField.getName(), (String)"required", (Object)(!ddmFormField.isRequired() ? 1 : 0));
            this._ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
        }
    }

    protected void checkFieldAffectedBySetVisibleAction(DDMFormRule ddmFormRule, DDMFormField ddmFormField) {
        if (this.containsAction(ddmFormRule, "setVisible", ddmFormField.getName(), true)) {
            UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)ddmFormField.getName(), (String)"visible", (Object)false);
            this._ddmFormEvaluatorExpressionObserver.updateFieldProperty(builder.build());
        }
    }

    protected boolean containsAction(DDMFormRule ddmFormRule, String functionName, String ddmFormFieldName, boolean defaultValue) {
        String setBooleanPropertyAction = String.format("%s('%s', %s)", functionName, ddmFormFieldName, defaultValue);
        List actions = ddmFormRule.getActions();
        Stream stream = actions.parallelStream();
        return stream.anyMatch(action -> Objects.equals(setBooleanPropertyAction, action));
    }
}

