/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.function;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessorAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;

public class BelongsToRoleFunction
implements DDMExpressionFunction.Function1<String[], Boolean>,
DDMExpressionParameterAccessorAware {
    public static final String NAME = "belongsTo";
    protected RoleLocalService roleLocalService;
    protected UserGroupRoleLocalService userGroupRoleLocalService;
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BelongsToRoleFunction.class);
    private DDMExpressionParameterAccessor _ddmExpressionParameterAccessor;

    public BelongsToRoleFunction(RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        this.roleLocalService = roleLocalService;
        this.userGroupRoleLocalService = userGroupRoleLocalService;
        this.userLocalService = userLocalService;
    }

    public Boolean apply(String[] roles) {
        block4: {
            if (this._ddmExpressionParameterAccessor == null) {
                return false;
            }
            try {
                long companyId = this._ddmExpressionParameterAccessor.getCompanyId();
                long groupId = this._ddmExpressionParameterAccessor.getGroupId();
                long userId = this._ddmExpressionParameterAccessor.getUserId();
                for (String roleName : roles) {
                    boolean belongsTo;
                    Role role = this.roleLocalService.fetchRole(companyId, roleName);
                    if (role == null || !(userId == 0L ? roleName.equals("Guest") : (belongsTo = role.getType() == 1 ? this.userLocalService.hasRoleUser(companyId, roleName, userId, true) : this.userGroupRoleLocalService.hasUserGroupRole(userId, groupId, roleName, true)))) continue;
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
        return false;
    }

    public String getName() {
        return NAME;
    }

    public void setDDMExpressionParameterAccessor(DDMExpressionParameterAccessor ddmExpressionParameterAccessor) {
        this._ddmExpressionParameterAccessor = ddmExpressionParameterAccessor;
    }
}

