/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.functions;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.BaseDDMFormRuleFunction;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GetValueFunction
extends BaseDDMFormRuleFunction {
    private final Map<String, DDMFormField> _ddmFormFields;
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;

    public GetValueFunction(Map<String, DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldEvaluationResult>> ddmFormFieldEvaluationResultsMap, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        super(ddmFormFieldEvaluationResultsMap);
        this._ddmFormFields = ddmFormFields;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    public Object evaluate(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("One parameter is expected");
        }
        String ddmFormFieldName = parameters[0].toString();
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = this.getDDMFormFieldEvaluationResults(ddmFormFieldName);
        Stream ddmFormFieldEvaluationResultStream = ddmFormFieldEvaluationResults.stream();
        Stream<Object> valueStream = ddmFormFieldEvaluationResultStream.map(result -> this.map(ddmFormFieldName, result.getValue()));
        Set valuesSet = valueStream.collect(Collectors.toSet());
        Object[] values = valuesSet.toArray();
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    protected Object map(String ddmFormFieldName, Object value) {
        DDMFormField ddmFormField = this._ddmFormFields.get(ddmFormFieldName);
        if (ddmFormField == null) {
            return value;
        }
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueAccessor(ddmFormField.getType());
        if (ddmFormFieldValueAccessor == null) {
            return value;
        }
        return ddmFormFieldValueAccessor.map(value);
    }
}

