/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.functions;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInvoker;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.BaseDDMFormRuleFunction;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class CallFunction
extends BaseDDMFormRuleFunction {
    private static final Log _log = LogFactoryUtil.getLog(CallFunction.class);
    private final DDMDataProviderInvoker _ddmDataProviderInvoker;
    private final Map<String, List<DDMFormFieldEvaluationResult>> _ddmFormFieldEvaluationResults;
    private final HttpServletRequest _httpServletRequest;
    private final JSONFactory _jsonFactory;

    public CallFunction(DDMDataProviderInvoker ddmDataProviderInvoker, Map<String, List<DDMFormFieldEvaluationResult>> ddmFormFieldEvaluationResults, HttpServletRequest httpServletRequest, JSONFactory jsonFactory) {
        super(ddmFormFieldEvaluationResults);
        this._ddmDataProviderInvoker = ddmDataProviderInvoker;
        this._ddmFormFieldEvaluationResults = ddmFormFieldEvaluationResults;
        this._httpServletRequest = httpServletRequest;
        this._jsonFactory = jsonFactory;
    }

    public Object evaluate(Object ... parameters) {
        block3: {
            if (parameters.length < 3) {
                throw new IllegalArgumentException(String.format("Expected 3 parameters, received %d", parameters.length));
            }
            String ddmDataProviderInstanceUUID = String.valueOf(parameters[0]);
            String paramsExpression = String.valueOf(parameters[1]);
            String resultMapExpression = String.valueOf(parameters[2]);
            try {
                DDMDataProviderRequest ddmDataProviderRequest = new DDMDataProviderRequest(ddmDataProviderInstanceUUID, this._httpServletRequest);
                this.addDDMDataProviderRequestParameters(ddmDataProviderRequest, paramsExpression);
                DDMDataProviderResponse ddmDataProviderResponse = this._ddmDataProviderInvoker.invoke(ddmDataProviderRequest);
                Map<String, String> resultMap = this.extractResults(resultMapExpression);
                this.setDDMFormFieldValues(ddmDataProviderResponse, resultMap);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Error evaluating expression: " + ArrayUtil.toString((Object[])parameters, (String)null)), (Throwable)e);
            }
        }
        return true;
    }

    protected void addDDMDataProviderRequestParameters(DDMDataProviderRequest ddmDataProviderRequest, String paramsExpression) {
        Map<String, String> parameters = this.extractParameters(paramsExpression);
        if (!parameters.isEmpty()) {
            ddmDataProviderRequest.queryString(parameters);
        }
    }

    protected void extractDDMFormFieldValue(String expression, Map<String, String> parameters) {
        String[] tokens = StringUtil.split((String)expression, (char)'=');
        String parameterName = tokens[0];
        String parameterValue = "";
        if (tokens.length == 2) {
            parameterValue = tokens[1];
        }
        if (this._ddmFormFieldEvaluationResults.containsKey(parameterValue)) {
            String ddmFormFieldValue = this.getDDMFormFieldValue(parameterValue);
            parameters.put(parameterName, ddmFormFieldValue);
        } else {
            parameters.put(parameterName, parameterValue);
        }
    }

    protected Map<String, String> extractParameters(String expression) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] innerExpressions = StringUtil.split((String)expression, (char)';');
        if (innerExpressions.length == 0) {
            this.extractDDMFormFieldValue(expression, parameters);
        } else {
            for (String innerExpression : innerExpressions) {
                this.extractDDMFormFieldValue(innerExpression, parameters);
            }
        }
        return parameters;
    }

    protected Map<String, String> extractResults(String resultMapExpression) {
        String[] innerExpressions;
        if (Validator.isNull((String)resultMapExpression)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String innerExpression : innerExpressions = StringUtil.split((String)resultMapExpression, (char)';')) {
            String[] tokens = StringUtil.split((String)innerExpression, (char)'=');
            results.put(tokens[0], tokens[1]);
        }
        return results;
    }

    protected DDMFormFieldEvaluationResult getDDMFormFieldEvaluationResult(String ddmFormFieldName) {
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResultList = this.getDDMFormFieldEvaluationResultList(ddmFormFieldName);
        if (ddmFormFieldEvaluationResultList.isEmpty()) {
            return null;
        }
        return ddmFormFieldEvaluationResultList.get(0);
    }

    protected List<DDMFormFieldEvaluationResult> getDDMFormFieldEvaluationResultList(String ddmFormFieldName) {
        if (!this._ddmFormFieldEvaluationResults.containsKey(ddmFormFieldName)) {
            return Collections.emptyList();
        }
        return this._ddmFormFieldEvaluationResults.get(ddmFormFieldName);
    }

    protected String getDDMFormFieldValue(String ddmFormFieldName) {
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.getDDMFormFieldEvaluationResult(ddmFormFieldName);
        if (ddmFormFieldEvaluationResult == null) {
            return "";
        }
        Object value = ddmFormFieldEvaluationResult.getProperty("value");
        if (Validator.isNull((Object)value)) {
            return "";
        }
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(String.valueOf(value));
            return (String)jsonArray.get(0);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsone, (Throwable)jsone);
            }
            return String.valueOf(value);
        }
    }

    protected void setDDMFormFieldOptions(DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult, List<KeyValuePair> options) {
        if (ddmFormFieldEvaluationResult == null) {
            return;
        }
        ddmFormFieldEvaluationResult.setProperty("options", options);
        if (options.size() == 1) {
            KeyValuePair keyValuePair = options.get(0);
            JSONArray valueJSONArray = this._jsonFactory.createJSONArray();
            valueJSONArray.put(keyValuePair.getValue());
            ddmFormFieldEvaluationResult.setValue((Object)valueJSONArray);
        }
    }

    protected void setDDMFormFieldOptions(String ddmFormFieldName, List<KeyValuePair> options) {
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResultList = this.getDDMFormFieldEvaluationResultList(ddmFormFieldName);
        for (DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult : ddmFormFieldEvaluationResultList) {
            this.setDDMFormFieldOptions(ddmFormFieldEvaluationResult, options);
        }
    }

    protected void setDDMFormFieldValue(String ddmFormFieldName, String value) {
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.getDDMFormFieldEvaluationResult(ddmFormFieldName);
        if (ddmFormFieldEvaluationResult != null) {
            ddmFormFieldEvaluationResult.setValue((Object)value);
            ddmFormFieldEvaluationResult.setProperty("valueChanged", (Object)true);
        }
    }

    protected void setDDMFormFieldValues(DDMDataProviderResponse ddmDataProviderResponse, Map<String, String> resultMap) {
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String outputName = entry.getValue();
            DDMDataProviderResponseOutput ddmDataProviderResponseOutput = ddmDataProviderResponse.get(outputName);
            if (ddmDataProviderResponseOutput == null) continue;
            String ddmFormFieldName = entry.getKey();
            if (Objects.equals(ddmDataProviderResponseOutput.getType(), "list")) {
                List options = (List)ddmDataProviderResponseOutput.getValue(List.class);
                this.setDDMFormFieldOptions(ddmFormFieldName, (List<KeyValuePair>)options);
                continue;
            }
            String value = (String)ddmDataProviderResponseOutput.getValue(String.class);
            this.setDDMFormFieldValue(ddmFormFieldName, value);
        }
    }
}

