/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.DDMExpressionFunctionRegistry;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public class DDMFormRuleEvaluator {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormRuleEvaluator.class);
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DDMExpressionFunctionRegistry _ddmExpressionFunctionRegistry;
    private final DDMFormRule _ddmFormRule;

    public DDMFormRuleEvaluator(DDMFormRule ddmFormRule, DDMExpressionFactory ddmExpressionFactory, DDMExpressionFunctionRegistry ddmExpressionFunctionRegistry) {
        this._ddmFormRule = ddmFormRule;
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._ddmExpressionFunctionRegistry = ddmExpressionFunctionRegistry;
    }

    public void evaluate() {
        if (!this._ddmFormRule.isEnabled()) {
            return;
        }
        boolean conditionEvaluationResult = this.evaluateCondition(this._ddmFormRule.getCondition());
        if (!conditionEvaluationResult) {
            return;
        }
        for (String action : this._ddmFormRule.getActions()) {
            this.executeAction(action);
        }
    }

    protected boolean evaluateCondition(String condition) {
        try {
            return this.evaluateDDMExpression(condition);
        }
        catch (DDMExpressionException ddmee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ddmee, (Throwable)ddmee);
            }
            return false;
        }
    }

    protected boolean evaluateDDMExpression(String ddmExpressionString) throws DDMExpressionException {
        DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(ddmExpressionString);
        this._ddmExpressionFunctionRegistry.applyDDMExpressionFunctions(ddmExpression);
        return (Boolean)ddmExpression.evaluate();
    }

    protected void executeAction(String action) {
        block2: {
            try {
                this.evaluateDDMExpression(action);
            }
            catch (DDMExpressionException ddmee) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)ddmee, (Throwable)ddmee);
            }
        }
    }
}

