/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.functions;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.DDMExpressionFunctionRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.stream.Stream;

public class AllFunction
implements DDMExpressionFunction {
    private static final Log _log = LogFactoryUtil.getLog(AllFunction.class);
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DDMExpressionFunctionRegistry _ddmExpressionFunctionRegistry;

    public AllFunction(DDMExpressionFactory ddmExpressionFactory, DDMExpressionFunctionRegistry ddmExpressionFunctionRegistry) {
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._ddmExpressionFunctionRegistry = ddmExpressionFunctionRegistry;
    }

    public Object evaluate(Object ... parameters) {
        if (parameters == null || parameters.length < 1) {
            throw new IllegalArgumentException("At least one parameter is expected");
        }
        if (parameters.length == 1) {
            return false;
        }
        String expression = String.valueOf(parameters[0]);
        if (!expression.contains("#value#")) {
            return false;
        }
        Object[] values = null;
        if (this.isArray(parameters[1])) {
            values = (Object[])parameters[1];
            if (values.length == 0) {
                return false;
            }
        } else {
            values = new Object[]{parameters[1]};
        }
        return Stream.of(values).allMatch(value -> this.accept(expression, value));
    }

    protected boolean accept(String expression, Object value) {
        expression = expression.replace("#value#", String.valueOf(value));
        try {
            DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(expression);
            this._ddmExpressionFunctionRegistry.applyDDMExpressionFunctions(ddmExpression);
            return (Boolean)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ddmee, (Throwable)ddmee);
            }
            return false;
        }
    }

    protected boolean isArray(Object parameter) {
        Class<?> clazz = parameter.getClass();
        return clazz.isArray();
    }
}

