/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInvoker;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationException;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorContext;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.DDMExpressionFunctionRegistry;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.DDMFormEvaluationResultBuilder;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.DDMFormRuleEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.AllFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.BelongsToRoleFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.CallFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.GetValueFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.JumpPageFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.SetEnabledFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.SetInvalidFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.SetOptionsFunction;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.SetPropertyFunction;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.FieldConstants;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DDMFormEvaluatorHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEvaluatorHelper.class);
    private final DDMDataProviderInvoker _ddmDataProviderInvoker;
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DDMExpressionFunctionRegistry _ddmExpressionFunctionRegistry = new DDMExpressionFunctionRegistry();
    private final DDMForm _ddmForm;
    private final Map<String, List<DDMFormFieldEvaluationResult>> _ddmFormFieldEvaluationResultsMap = new HashMap<String, List<DDMFormFieldEvaluationResult>>();
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final Map<String, List<DDMFormFieldValue>> _ddmFormFieldValuesMap = new LinkedHashMap<String, List<DDMFormFieldValue>>();
    private final DDMFormFieldValueAccessor<String> _defaultDDMFormFieldValueAccessor = new DefaultDDMFormFieldValueAccessor();
    private final long _groupId;
    private final JSONFactory _jsonFactory;
    private final Locale _locale;
    private final Map<Integer, Integer> _pageFlow = new HashMap<Integer, Integer>();
    private final HttpServletRequest _request;
    private final ResourceBundle _resourceBundle;
    private final RoleLocalService _roleLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;

    public DDMFormEvaluatorHelper(DDMDataProviderInvoker ddmDataProviderInvoker, DDMExpressionFactory ddmExpressionFactory, DDMFormEvaluatorContext ddmFormEvaluatorContext, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, JSONFactory jsonFactory, RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        this._ddmDataProviderInvoker = ddmDataProviderInvoker;
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this._jsonFactory = jsonFactory;
        this._roleLocalService = roleLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._userLocalService = userLocalService;
        this._ddmForm = ddmFormEvaluatorContext.getDDMForm();
        this._ddmFormFieldsMap = this._ddmForm.getDDMFormFieldsMap(true);
        this._groupId = (Long)ddmFormEvaluatorContext.getProperty("groupId");
        this._locale = ddmFormEvaluatorContext.getLocale();
        this._request = (HttpServletRequest)ddmFormEvaluatorContext.getProperty("request");
        this.createDDMFormFieldValues(ddmFormEvaluatorContext.getDDMFormValues());
        this.createDDMFormFieldRuleEvaluationResultsMap();
        this._resourceBundle = this.createResourceBundle();
        this.registerDDMExpressionCustomFunctions();
    }

    public DDMFormEvaluationResult evaluate() throws DDMFormEvaluationException {
        for (DDMFormRule ddmFormRule : this._ddmForm.getDDMFormRules()) {
            this.evaluateDDMFormRule(ddmFormRule);
        }
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = this.getDDMFormFieldEvaluationResults();
        this.setDDMFormFieldEvaluationResultsValidation(ddmFormFieldEvaluationResults);
        return DDMFormEvaluationResultBuilder.build(ddmFormFieldEvaluationResults, this.getDisabledPagesIndexes());
    }

    protected Object convertToTargetDataType(DDMFormField ddmFormField, Object value) {
        if (value instanceof JSONArray) {
            return value;
        }
        String dataType = ddmFormField.getDataType();
        if (FieldConstants.isNumericType((String)dataType) || dataType.equals("boolean") || dataType.equals("date")) {
            return FieldConstants.getSerializable((String)ddmFormField.getDataType(), (String)String.valueOf(value));
        }
        return value;
    }

    protected DDMFormFieldEvaluationResult createDDMFormFieldEvaluationResult(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = new DDMFormFieldEvaluationResult(ddmFormField.getName(), ddmFormFieldValue.getInstanceId());
        this.setDDMFormFieldEvaluationResultDataType(ddmFormField, ddmFormFieldEvaluationResult);
        this.setDDMFormFieldEvaluationResultReadOnly(ddmFormFieldEvaluationResult, ddmFormField);
        this.setDDMFormFieldEvaluationResultRequired(ddmFormFieldEvaluationResult, ddmFormField);
        this.setDDMFormFieldEvaluationResultVisibility(ddmFormFieldEvaluationResult, ddmFormField, ddmFormFieldValue);
        this.setDDMFormFieldEvaluationResultValidation(ddmFormFieldEvaluationResult, ddmFormField, ddmFormFieldValue);
        Object value = this.getValue(ddmFormField, ddmFormFieldValue);
        ddmFormFieldEvaluationResult.setValue(this.convertToTargetDataType(ddmFormField, value));
        return ddmFormFieldEvaluationResult;
    }

    protected void createDDMFormFieldRuleEvaluationResultsMap() {
        Map ddmFormFieldMap = this._ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldMap.values()) {
            this.createDDMFormFieldRuleEvaluationResultsMap(ddmFormField);
        }
    }

    protected void createDDMFormFieldRuleEvaluationResultsMap(DDMFormField ddmFormField) {
        ArrayList<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResultInstances = new ArrayList<DDMFormFieldEvaluationResult>();
        List<DDMFormFieldValue> ddmFormFieldValues = this._ddmFormFieldValuesMap.get(ddmFormField.getName());
        if (ddmFormFieldValues == null) {
            return;
        }
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.createDDMFormFieldEvaluationResult(ddmFormField, ddmFormFieldValue);
            ddmFormFieldEvaluationResultInstances.add(ddmFormFieldEvaluationResult);
            for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                DDMFormField nestedDDMFormField = nestedDDMFormFieldValue.getDDMFormField();
                ddmFormFieldEvaluationResult = this.createDDMFormFieldEvaluationResult(nestedDDMFormField, nestedDDMFormFieldValue);
                ddmFormFieldEvaluationResultInstances.add(ddmFormFieldEvaluationResult);
            }
        }
        this._ddmFormFieldEvaluationResultsMap.put(ddmFormField.getName(), ddmFormFieldEvaluationResultInstances);
    }

    protected void createDDMFormFieldValues(DDMFormValues ddmFormValues) {
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this.populateDDMFormFieldValues(ddmFormFieldValue);
        }
    }

    protected ResourceBundle createResourceBundle() {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        ResourceBundle portalResourceBundle = portalResourceBundleLoader.loadResourceBundle(this._locale);
        ResourceBundle portletResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._locale, this.getClass());
        return new AggregateResourceBundle(new ResourceBundle[]{portletResourceBundle, portalResourceBundle});
    }

    protected void evaluateDDMFormRule(DDMFormRule ddmFormRule) throws DDMFormEvaluationException {
        DDMFormRuleEvaluator ddmFormRuleEvaluator = new DDMFormRuleEvaluator(ddmFormRule, this._ddmExpressionFactory, this._ddmExpressionFunctionRegistry);
        ddmFormRuleEvaluator.evaluate();
    }

    protected List<DDMFormFieldEvaluationResult> getDDMFormFieldEvaluationResults() {
        ArrayList<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = new ArrayList<DDMFormFieldEvaluationResult>();
        for (List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResultInstances : this._ddmFormFieldEvaluationResultsMap.values()) {
            ddmFormFieldEvaluationResults.addAll(ddmFormFieldEvaluationResultInstances);
        }
        return ddmFormFieldEvaluationResults;
    }

    protected String getDDMFormFieldValidationErrorMessage(DDMFormFieldValidation ddmFormFieldValidation) {
        String errorMessage = ddmFormFieldValidation.getErrorMessage();
        if (Validator.isNotNull((String)errorMessage)) {
            return errorMessage;
        }
        return LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"this-field-is-invalid");
    }

    protected DDMFormFieldValue getDDMFormFieldValue(String ddmFormFieldName, String instanceId) {
        List<DDMFormFieldValue> ddmFormFieldValues = this._ddmFormFieldValuesMap.get(ddmFormFieldName);
        if (ListUtil.isEmpty(ddmFormFieldValues)) {
            return null;
        }
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (instanceId.equals(ddmFormFieldValue.getInstanceId())) {
                return ddmFormFieldValue;
            }
            for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                if (!instanceId.equals(nestedDDMFormFieldValue.getInstanceId())) continue;
                return nestedDDMFormFieldValue;
            }
        }
        return null;
    }

    protected DDMFormFieldValueAccessor<?> getDDMFormFieldValueAccessor(String type) {
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueAccessor(type);
        if (ddmFormFieldValueAccessor != null) {
            return ddmFormFieldValueAccessor;
        }
        return this._defaultDDMFormFieldValueAccessor;
    }

    protected boolean getDefaultBooleanPropertyState(String functionName, String ddmFormFieldName, boolean defaultValue) {
        String setFieldAction = String.format("%s('%s', true)", functionName, ddmFormFieldName);
        for (DDMFormRule ddmFormRule : this._ddmForm.getDDMFormRules()) {
            for (String action : ddmFormRule.getActions()) {
                if (!Objects.equals(setFieldAction, action)) continue;
                return false;
            }
        }
        return defaultValue;
    }

    protected Set<Integer> getDisabledPagesIndexes() {
        HashSet<Integer> disabledPagesIndexes = new HashSet<Integer>();
        for (Map.Entry<Integer, Integer> entry : this._pageFlow.entrySet()) {
            int fromPageIndex = entry.getKey();
            int toPageIndex = entry.getValue();
            for (int i = fromPageIndex + 1; i < toPageIndex; ++i) {
                disabledPagesIndexes.add(i);
            }
        }
        return disabledPagesIndexes;
    }

    protected Object getValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        if (ddmFormFieldValue == null) {
            return null;
        }
        DDMFormFieldValueAccessor<?> ddmFormFieldValueAccessor = this.getDDMFormFieldValueAccessor(ddmFormField.getType());
        return ddmFormFieldValueAccessor.getValue(ddmFormFieldValue, this._locale);
    }

    protected boolean isDDMFormFieldValueEmpty(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        DDMFormFieldValueAccessor<?> ddmFormFieldValueAccessor = this.getDDMFormFieldValueAccessor(ddmFormField.getType());
        return ddmFormFieldValueAccessor.isEmpty(ddmFormFieldValue, this._locale);
    }

    protected void populateDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue) {
        List<DDMFormFieldValue> ddmFormFieldValues = this._ddmFormFieldValuesMap.get(ddmFormFieldValue.getName());
        if (ddmFormFieldValues == null) {
            ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
            this._ddmFormFieldValuesMap.put(ddmFormFieldValue.getName(), ddmFormFieldValues);
        }
        ddmFormFieldValues.add(ddmFormFieldValue);
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.populateDDMFormFieldValues(nestedDDMFormFieldValue);
        }
    }

    protected void registerDDMExpressionCustomFunctions() {
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("all", new AllFunction(this._ddmExpressionFactory, this._ddmExpressionFunctionRegistry));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("belongsTo", new BelongsToRoleFunction(this._request, this._groupId, this._roleLocalService, this._userGroupRoleLocalService, this._userLocalService));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("calculate", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "value"));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("call", new CallFunction(this._ddmDataProviderInvoker, this._ddmFormFieldEvaluationResultsMap, this._request, this._jsonFactory));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("getValue", new GetValueFunction(this._ddmForm.getDDMFormFieldsMap(true), this._ddmFormFieldEvaluationResultsMap, this._ddmFormFieldTypeServicesTracker));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("jumpPage", new JumpPageFunction(this._pageFlow));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setDataType", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "dataType"));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setEnabled", new SetEnabledFunction(this._ddmFormFieldEvaluationResultsMap));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setInvalid", new SetInvalidFunction(this._ddmFormFieldEvaluationResultsMap));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setOptions", new SetOptionsFunction(this._ddmFormFieldEvaluationResultsMap, this._locale, this._jsonFactory));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setMultiple", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "multiple"));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setRequired", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "required"));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setValidationDataType", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "validationDataType"));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setValue", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "value"));
        this._ddmExpressionFunctionRegistry.registerDDMExpressionFunction("setVisible", new SetPropertyFunction(this._ddmFormFieldEvaluationResultsMap, "visible"));
    }

    protected void setDDMExpressionVariables(DDMExpression<Boolean> ddmExpression, DDMFormFieldValue ddmFormFieldValue) throws DDMExpressionException {
        for (Map.Entry<String, List<DDMFormFieldValue>> entry : this._ddmFormFieldValuesMap.entrySet()) {
            String ddmFormFieldName = entry.getKey();
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldName);
            List<DDMFormFieldValue> ddmFormFieldValues = entry.getValue();
            DDMFormFieldValue selectedDDMFormFieldValue = ddmFormFieldValues.get(0);
            if (ddmFormFieldName.equals(ddmFormFieldValue.getName())) {
                selectedDDMFormFieldValue = ddmFormFieldValue;
            }
            Object value = this.getValue(ddmFormField, selectedDDMFormFieldValue);
            String dataType = ddmFormField.getDataType();
            if (FieldConstants.isNumericType((String)ddmFormField.getDataType())) {
                if (!Validator.isNotNull((Object)value)) continue;
                ddmExpression.setDoubleVariableValue(ddmFormFieldName, Double.valueOf(GetterUtil.getDouble((Object)value)));
                continue;
            }
            if (dataType.equals("boolean")) {
                if (!Validator.isNotNull((Object)value)) continue;
                ddmExpression.setBooleanVariableValue(ddmFormFieldName, Boolean.valueOf(GetterUtil.getBoolean((Object)value)));
                continue;
            }
            ddmExpression.setObjectVariableValue(ddmFormFieldName, value);
        }
    }

    protected void setDDMFormFieldEvaluationResultDataType(DDMFormField ddmFormField, DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult) {
        ddmFormFieldEvaluationResult.setProperty("dataType", (Object)ddmFormField.getDataType());
    }

    protected void setDDMFormFieldEvaluationResultReadOnly(DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult, DDMFormField ddmFormField) {
        boolean enabled = this.getDefaultBooleanPropertyState("setEnabled", ddmFormField.getName(), !ddmFormField.isReadOnly());
        ddmFormFieldEvaluationResult.setReadOnly(!enabled);
    }

    protected void setDDMFormFieldEvaluationResultRequired(DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult, DDMFormField ddmFormField) {
        boolean required = this.getDefaultBooleanPropertyState("setRequired", ddmFormField.getName(), ddmFormField.isRequired());
        ddmFormFieldEvaluationResult.setRequired(required);
    }

    protected void setDDMFormFieldEvaluationResultsValidation(List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults) {
        for (DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult : ddmFormFieldEvaluationResults) {
            String ddmFormFieldName = ddmFormFieldEvaluationResult.getName();
            DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(ddmFormFieldName, ddmFormFieldEvaluationResult.getInstanceId());
            this.setDDMFormFieldEvaluationResultValidation(ddmFormFieldEvaluationResult, this._ddmFormFieldsMap.get(ddmFormFieldName), ddmFormFieldValue);
        }
    }

    protected void setDDMFormFieldEvaluationResultValidation(DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        block7: {
            boolean required = ddmFormFieldEvaluationResult.isRequired();
            boolean emptyValue = this.isDDMFormFieldValueEmpty(ddmFormField, ddmFormFieldValue);
            if (!required && emptyValue) {
                return;
            }
            boolean visible = ddmFormFieldEvaluationResult.isVisible();
            if (required && visible && emptyValue) {
                ddmFormFieldEvaluationResult.setErrorMessage(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"this-field-is-required"));
                ddmFormFieldEvaluationResult.setValid(false);
                return;
            }
            DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
            if (ddmFormFieldValidation == null) {
                return;
            }
            String validationExpression = ddmFormFieldValidation.getExpression();
            if (Validator.isNull((String)validationExpression)) {
                return;
            }
            try {
                DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(validationExpression);
                this.setDDMExpressionVariables((DDMExpression<Boolean>)ddmExpression, ddmFormFieldValue);
                boolean valid = (Boolean)ddmExpression.evaluate();
                if (!valid) {
                    ddmFormFieldEvaluationResult.setErrorMessage(this.getDDMFormFieldValidationErrorMessage(ddmFormFieldValidation));
                    ddmFormFieldEvaluationResult.setValid(false);
                }
            }
            catch (DDMExpressionException ddmee) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)String.format("Error processing validation expression \"%s\" for field \"%s\"", validationExpression, ddmFormField.getName()), (Throwable)ddmee);
            }
        }
    }

    protected void setDDMFormFieldEvaluationResultVisibility(DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        block3: {
            String visibilityExpression = ddmFormField.getVisibilityExpression();
            if (Validator.isNull((String)visibilityExpression) || StringUtil.equalsIgnoreCase((String)visibilityExpression, (String)"TRUE")) {
                boolean defaultState = this.getDefaultBooleanPropertyState("setVisible", ddmFormField.getName(), true);
                ddmFormFieldEvaluationResult.setVisible(defaultState);
                return;
            }
            try {
                DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(visibilityExpression);
                this.setDDMExpressionVariables((DDMExpression<Boolean>)ddmExpression, ddmFormFieldValue);
                ddmFormFieldEvaluationResult.setVisible(((Boolean)ddmExpression.evaluate()).booleanValue());
            }
            catch (DDMExpressionException ddmee) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)String.format("Error processing visibility expression \"%s\" for field \"%s\"", visibilityExpression, ddmFormField.getName()), (Throwable)ddmee);
            }
        }
    }
}

