Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.50/js/util/dragAndDrop.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', './fieldSupport.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.disableFieldSetDropTargets = exports.disableFieldSetDragSources = exports.disableFieldDropTargets = void 0;

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    var _fieldSupport = require("./fieldSupport.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var disableFieldDropTargets = function disableFieldDropTargets(element) {
      var dropTargets = element.querySelectorAll('.ddm-target');

      for (var i = 0; i < dropTargets.length; i++) {
        var target = dropTargets[i];

        var parentFieldNode = _metalDom["default"].closest(target, '.ddm-field-container');

        if (parentFieldNode) {
          target.setAttribute('data-drop-disabled', true);
        }
      }
    };

    exports.disableFieldDropTargets = disableFieldDropTargets;

    var disableFieldSetDragSources = function disableFieldSetDragSources(element, pages) {
      var dragSources = element.querySelectorAll('.ddm-drag');

      for (var i = 0; i < dragSources.length; i++) {
        var source = dragSources[i];
        var fieldName = source.parentElement.dataset.fieldName;

        if ((0, _fieldSupport.isFieldSetChild)(pages, fieldName)) {
          source.setAttribute('data-drag-disabled', true);
        }
      }
    };

    exports.disableFieldSetDragSources = disableFieldSetDragSources;

    var disableFieldSetDropTargets = function disableFieldSetDropTargets(element, pages) {
      var dropTargets = element.querySelectorAll('.ddm-target');

      for (var i = 0; i < dropTargets.length; i++) {
        var target = dropTargets[i];

        var parentFieldNode = _metalDom["default"].closest(target, '.ddm-field-container');

        if (parentFieldNode) {
          var fieldName = parentFieldNode.dataset.fieldName;
          var parentField = (0, _fieldSupport.getField)(pages, fieldName);

          if (parentField && (0, _fieldSupport.isFieldSet)(parentField) || (0, _fieldSupport.isFieldSetChild)(pages, fieldName)) {
            target.setAttribute('data-drop-disabled', true);
          }
        }
      }
    };

    exports.disableFieldSetDropTargets = disableFieldSetDropTargets;
    //# sourceMappingURL=dragAndDrop.es.js.map
  }
});
//# sourceMappingURL=dragAndDrop.es.js.map