Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.28/js/components/LayoutProvider/handlers/fieldEditedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../util/rules.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleFieldEdited = exports.updateState = exports.updatePages = void 0;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _rules = require("../util/rules.es");

  var _settingsContext = require("../util/settingsContext.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var updatePages = function updatePages(props, pages, previousFieldName, newField) {
    var parentFieldName;
    var visitor = new _visitors.PagesVisitor(pages);
    var newFieldName = newField.fieldName;
    var newPages = visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex, parentField) {
      if (field.fieldName === previousFieldName) {
        if (parentField) {
          parentFieldName = parentField.fieldName;
        }

        return newField;
      }

      return field;
    }, true, true);

    if (parentFieldName && previousFieldName !== newFieldName) {
      visitor.setPages(newPages);
      newPages = visitor.mapFields(function (field) {
        if (parentFieldName === field.fieldName) {
          var _visitor = new _visitors.PagesVisitor([{
            rows: field.rows
          }]);

          var layout = _visitor.mapColumns(function (column) {
            return _objectSpread({}, column, {
              fields: column.fields.map(function (fieldName) {
                if (fieldName === previousFieldName) {
                  return newFieldName;
                }

                return fieldName;
              })
            });
          });

          var rows = layout[0].rows;
          return _objectSpread({}, field, {
            rows: rows,
            settingsContext: (0, _settingsContext.updateSettingsContextProperty)(props.editingLanguageId, field.settingsContext, 'rows', rows)
          });
        }

        return field;
      }, true, true);
    }

    return newPages;
  };

  exports.updatePages = updatePages;

  var updateState = function updateState(props, state, propertyName, propertyValue) {
    var focusedField = state.focusedField,
        pages = state.pages,
        rules = state.rules;
    var previousFocusedFieldName = focusedField.fieldName;
    var newFocusedField = (0, _settingsContext.updateField)(props, focusedField, propertyName, propertyValue);
    var newPages = updatePages(props, pages, previousFocusedFieldName, newFocusedField);
    return {
      focusedField: newFocusedField,
      pages: newPages,
      rules: (0, _rules.updateRulesReferences)(rules || [], focusedField, newFocusedField)
    };
  };

  exports.updateState = updateState;

  var handleFieldEdited = function handleFieldEdited(props, state, event) {
    var propertyName = event.propertyName,
        propertyValue = event.propertyValue;
    var newState = {};

    if (propertyName !== 'name' || propertyValue !== '') {
      newState = updateState(props, state, propertyName, propertyValue);
    }

    return newState;
  };

  exports.handleFieldEdited = handleFieldEdited;
  var _default = handleFieldEdited;
  exports["default"] = _default;
  //# sourceMappingURL=fieldEditedHandler.es.js.map
});
//# sourceMappingURL=fieldEditedHandler.es.js.map