Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.86/js/components/FormBuilder/withResizeableColumns.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-jsx', './props.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _props = _interopRequireDefault(require("./props.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var MAX_COLUMNS = 12;

  var withResizeableColumns = function withResizeableColumns(ChildComponent) {
    var ResizeableColumns = /*#__PURE__*/function (_Component) {
      _inherits(ResizeableColumns, _Component);

      function ResizeableColumns() {
        _classCallCheck(this, ResizeableColumns);

        return _possibleConstructorReturn(this, _getPrototypeOf(ResizeableColumns).apply(this, arguments));
      }

      _createClass(ResizeableColumns, [{
        key: "attached",
        value: function attached() {
          this._createResizeDrag();
        }
      }, {
        key: "disposeInternal",
        value: function disposeInternal() {
          _get(_getPrototypeOf(ResizeableColumns.prototype), "disposeInternal", this).call(this);

          if (this._resizeDrag) {
            this._resizeDrag.dispose();
          }
        }
      }, {
        key: "isResizeEnabled",
        value: function isResizeEnabled() {
          var _this$props = this.props,
              defaultLanguageId = _this$props.defaultLanguageId,
              editingLanguageId = _this$props.editingLanguageId;
          return defaultLanguageId === editingLanguageId;
        }
      }, {
        key: "render",
        value: function render() {
          IncrementalDOM.elementOpen("div", null, null, "class", this.isResizeEnabled() ? 'resizeable' : '');
          IncrementalDOM.elementOpenStart(ChildComponent);
          iDOMHelpers.forOwn(this.props, iDOMHelpers.attr);
          IncrementalDOM.elementOpenEnd(ChildComponent);
          IncrementalDOM.elementClose(ChildComponent);
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "_createResizeDrag",
        value: function _createResizeDrag() {
          this._resizeDrag = new _metalDragDrop.Drag({
            axis: 'x',
            sources: '.resizeable .ddm-resize-handle',
            useShim: true
          });

          this._resizeDrag.on(_metalDragDrop.Drag.Events.END, this._handleDragEnd.bind(this));

          this._resizeDrag.on(_metalDragDrop.Drag.Events.DRAG, this._handleDragMove.bind(this));

          this._resizeDrag.on(_metalDragDrop.Drag.Events.START, this._handleDragStart.bind(this));
        }
      }, {
        key: "_handleDragEnd",
        value: function _handleDragEnd(_ref) {
          var source = _ref.source;
          var parentElement = source.parentElement;

          if (parentElement) {
            parentElement.classList.remove('dragging');
          }

          this._currentRow = null;
        }
      }, {
        key: "_handleDragStart",
        value: function _handleDragStart() {
          this._lastResizeColumn = -1;
        }
      }, {
        key: "_handleDragMove",
        value: function _handleDragMove(event) {
          var source = event.source;
          var store = this.context.store;

          if (!this._currentRow) {
            this._currentRow = _metalDom["default"].closest(source, '.row');
          }

          var container = this._currentRow.querySelector(['.col-ddm', "[data-ddm-field-column=\"".concat(source.dataset.ddmFieldColumn, "\"]"), "[data-ddm-field-page=\"".concat(source.dataset.ddmFieldPage, "\"]"), "[data-ddm-field-row=\"".concat(source.dataset.ddmFieldRow, "\"]"), '> .ddm-field-container'].join(''));

          if (container) {
            container.classList.add('dragging');
          }

          var column = Math.floor((event.x - this._currentRow.getBoundingClientRect().left) * (MAX_COLUMNS * 10) / this._currentRow.clientWidth / 10);

          if (column > MAX_COLUMNS - 1) {
            column = MAX_COLUMNS - 1;
          }

          if (column >= 0) {
            var direction = source.classList.contains('ddm-resize-handle-left') ? 'left' : 'right';

            if (this._lastResizeColumn !== column) {
              this._lastResizeColumn = column;
              store.emit('columnResized', {
                column: column,
                container: container,
                direction: direction,
                source: source
              });
            }
          }
        }
      }]);

      return ResizeableColumns;
    }(_metalJsx["default"]);

    ResizeableColumns.PROPS = _objectSpread({}, _props["default"]);
    return ResizeableColumns;
  };

  var _default = withResizeableColumns;
  exports["default"] = _default;
  //# sourceMappingURL=withResizeableColumns.es.js.map
});
//# sourceMappingURL=withResizeableColumns.es.js.map