Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.86/js/components/FormBuilder/FieldActionsDropDown.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../util/config.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.getFieldContainer = void 0;

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _config = require("../../util/config.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var getFieldContainer = function getFieldContainer(pages, fieldName) {
    return document.querySelector(".ddm-field-container[data-field-name=\"".concat(fieldName, "\"]"));
  };

  exports.getFieldContainer = getFieldContainer;

  var FieldActionsDropDown = /*#__PURE__*/function (_Component) {
    _inherits(FieldActionsDropDown, _Component);

    function FieldActionsDropDown() {
      _classCallCheck(this, FieldActionsDropDown);

      return _possibleConstructorReturn(this, _getPrototypeOf(FieldActionsDropDown).apply(this, arguments));
    }

    _createClass(FieldActionsDropDown, [{
      key: "created",
      value: function created() {
        this.on('fieldNameChanged', this._handleFieldNameChanged);
        this.expanded = false;
      }
    }, {
      key: "render",
      value: function render() {
        var expanded = this.expanded;
        var _this$props = this.props,
            disabled = _this$props.disabled,
            items = _this$props.items,
            label = _this$props.label,
            spritemap = _this$props.spritemap;
        IncrementalDOM.elementOpen("div", null, null, "onMouseDown", this._handleElementClicked.bind(this), "class", "ddm-field-actions-container");
        IncrementalDOM.elementOpen("span", null, null, "class", "actions-label");
        iDOMHelpers.renderArbitrary(label);
        IncrementalDOM.elementClose("span");
        IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "disabled", disabled, "events", {
          expandedChanged: this._handleExpandedChanged.bind(this),
          itemClicked: this._handleItemClicked.bind(this)
        }, "expanded", expanded, "items", items, "spritemap", spritemap, "ref", "dropdown");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "syncExpanded",
      value: function syncExpanded(expanded) {
        var pages = this.props.pages;
        var fieldName = this.state.fieldName;
        var fieldContainer = getFieldContainer(pages, fieldName);

        if (!fieldContainer) {
          return;
        }

        if (expanded) {
          fieldContainer.classList.add('expanded');
        } else {
          fieldContainer.classList.remove('expanded');
        }
      }
    }, {
      key: "_handleElementClicked",
      value: function _handleElementClicked(_ref) {
        var target = _ref.target;
        var disabled = this.props.disabled;
        var dropdown = this.refs.dropdown;

        if (!dropdown.element.contains(target)) {
          var dispatch = this.context.dispatch;
          var fieldName = this.state.fieldName;
          dispatch('fieldClicked', {
            fieldName: fieldName
          });
        } else if (!this.expanded && !disabled) {
          this.expanded = true;
        }
      }
    }, {
      key: "_handleExpandedChanged",
      value: function _handleExpandedChanged(_ref2) {
        var newVal = _ref2.newVal;
        this.expanded = newVal;
        this.syncExpanded(newVal);
      }
    }, {
      key: "_handleFieldNameChanged",
      value: function _handleFieldNameChanged(_ref3) {
        var newVal = _ref3.newVal,
            prevVal = _ref3.prevVal;
        var pages = this.props.pages;
        var expanded = this.state.expanded;
        var newFieldContainer = getFieldContainer(pages, newVal);
        var prevFieldContainer = getFieldContainer(pages, prevVal);

        if (prevFieldContainer && newFieldContainer !== prevFieldContainer) {
          prevFieldContainer.classList.remove('expanded');

          if (expanded && newFieldContainer) {
            newFieldContainer.classList.add('expanded');
          }
        }
      }
    }, {
      key: "_handleItemClicked",
      value: function _handleItemClicked(_ref4) {
        var action = _ref4.data.item.action;
        var fieldName = this.state.fieldName;
        action(fieldName);
        this.refs.dropdown.expanded = false;
      }
    }]);

    return FieldActionsDropDown;
  }(_metalJsx["default"]);

  FieldActionsDropDown.PROPS = {
    /**
     * @default false
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!boolean}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * @default undefined
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!string}
     */
    label: _metalState.Config.string(),

    /**
     * @default []
     * @instance
     * @memberof FieldActionsDropDown
     * @type {?array<object>}
     */
    pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

    /**
     * @default undefined
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };
  FieldActionsDropDown.STATE = {
    /**
     * @default {}
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!Object}
     */
    fieldName: _metalState.Config.string()
  };
  var _default = FieldActionsDropDown;
  exports["default"] = _default;
  //# sourceMappingURL=FieldActionsDropDown.es.js.map
});
//# sourceMappingURL=FieldActionsDropDown.es.js.map