/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor;

import com.liferay.dynamic.data.mapping.expression.model.AndExpression;
import com.liferay.dynamic.data.mapping.expression.model.BinaryExpression;
import com.liferay.dynamic.data.mapping.expression.model.ComparisonExpression;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.expression.model.FloatingPointLiteral;
import com.liferay.dynamic.data.mapping.expression.model.FunctionCallExpression;
import com.liferay.dynamic.data.mapping.expression.model.IntegerLiteral;
import com.liferay.dynamic.data.mapping.expression.model.NotExpression;
import com.liferay.dynamic.data.mapping.expression.model.OrExpression;
import com.liferay.dynamic.data.mapping.expression.model.StringLiteral;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRuleCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConditionExpressionVisitor
extends ExpressionVisitor<Object> {
    private static final Map<String, String> _functionNameOperatorMap = new HashMap<String, String>();
    private static final Map<String, String> _operatorMap = new HashMap<String, String>();
    private boolean _andOperator = true;
    private final Stack<DDMFormRuleCondition> _conditions = new Stack();

    public List<DDMFormRuleCondition> getConditions() {
        return this._conditions;
    }

    public String getLogicalOperator() {
        if (this._andOperator) {
            return "AND";
        }
        return "OR";
    }

    public Object visit(AndExpression andExpression) {
        this._andOperator = true;
        return this.doVisitLogicalExpression((BinaryExpression)andExpression);
    }

    public Object visit(ComparisonExpression comparisonExpression) {
        DDMFormRuleCondition.Operand leftOperand = (DDMFormRuleCondition.Operand)this.doVisit(comparisonExpression.getLeftOperandExpression());
        DDMFormRuleCondition.Operand rightOperand = (DDMFormRuleCondition.Operand)this.doVisit(comparisonExpression.getRightOperandExpression());
        DDMFormRuleCondition ddmFormRuleCondition = new DDMFormRuleCondition(_operatorMap.get(comparisonExpression.getOperator()), Arrays.asList(leftOperand, rightOperand));
        this._conditions.push(ddmFormRuleCondition);
        return this._conditions;
    }

    public Object visit(FloatingPointLiteral floatingPointLiteral) {
        return new DDMFormRuleCondition.Operand("double", floatingPointLiteral.getValue());
    }

    public Object visit(FunctionCallExpression functionCallExpression) {
        String functionName = functionCallExpression.getFunctionName();
        List parameterExpressions = functionCallExpression.getParameterExpressions();
        if (Objects.equals(functionName, "getValue")) {
            DDMFormRuleCondition.Operand operand = (DDMFormRuleCondition.Operand)this.doVisit((Expression)parameterExpressions.get(0));
            return new DDMFormRuleCondition.Operand("field", operand.getValue());
        }
        ArrayList<DDMFormRuleCondition.Operand> operands = new ArrayList<DDMFormRuleCondition.Operand>();
        for (Expression parameterExpression : parameterExpressions) {
            operands.add((DDMFormRuleCondition.Operand)this.doVisit(parameterExpression));
        }
        this._conditions.push(this.createDDMFormRuleCondition(functionName, operands));
        return this._conditions;
    }

    public Object visit(IntegerLiteral integerLiteral) {
        return new DDMFormRuleCondition.Operand("integer", integerLiteral.getValue());
    }

    public Object visit(NotExpression notExpression) {
        this.doVisit(notExpression.getOperandExpression());
        DDMFormRuleCondition condition = this._conditions.peek();
        String operator = condition.getOperator();
        condition.setOperator("not-" + operator);
        return this._conditions;
    }

    public Object visit(OrExpression orExpression) {
        this._andOperator = false;
        return this.doVisitLogicalExpression((BinaryExpression)orExpression);
    }

    public Object visit(StringLiteral stringLiteral) {
        return new DDMFormRuleCondition.Operand("string", stringLiteral.getValue());
    }

    protected DDMFormRuleCondition createBelongsToCondition(String belongsToFunctionName, List<DDMFormRuleCondition.Operand> operands) {
        ArrayList<DDMFormRuleCondition.Operand> belongsToOperands = new ArrayList<DDMFormRuleCondition.Operand>();
        Stream operandsStream = operands.stream();
        Stream<String> valuesStream = operandsStream.map(operand -> operand.getValue());
        belongsToOperands.add(new DDMFormRuleCondition.Operand("list", valuesStream.collect(Collectors.joining(","))));
        return new DDMFormRuleCondition(belongsToFunctionName, belongsToOperands);
    }

    protected DDMFormRuleCondition createDDMFormRuleCondition(String functionName, List<DDMFormRuleCondition.Operand> operands) {
        String functionNameOperator = _functionNameOperatorMap.get(functionName);
        if (Objects.equals(functionNameOperator, "belongs-to")) {
            return this.createBelongsToCondition(functionNameOperator, operands);
        }
        return new DDMFormRuleCondition(functionNameOperator, operands);
    }

    protected <T> T doVisit(Expression expression) {
        return (T)expression.accept((ExpressionVisitor)this);
    }

    protected List<DDMFormRuleCondition> doVisitLogicalExpression(BinaryExpression binaryExpression) {
        Object o1 = this.doVisit(binaryExpression.getLeftOperandExpression());
        Object o2 = this.doVisit(binaryExpression.getRightOperandExpression());
        if (o1 instanceof DDMFormRuleCondition) {
            this._conditions.push((DDMFormRuleCondition)o1);
        }
        if (o2 instanceof DDMFormRuleCondition) {
            this._conditions.push((DDMFormRuleCondition)o2);
        }
        return this._conditions;
    }

    static {
        _operatorMap.put("<", "less-than");
        _operatorMap.put("<=", "less-than-equals");
        _operatorMap.put(">", "greater-than");
        _operatorMap.put(">=", "greater-than-equals");
        _functionNameOperatorMap.put("belongsTo", "belongs-to");
        _functionNameOperatorMap.put("contains", "contains");
        _functionNameOperatorMap.put("equals", "equals-to");
        _functionNameOperatorMap.put("isEmpty", "is-empty");
    }
}

