/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionTracker;
import com.liferay.dynamic.data.mapping.expression.internal.helper.DDMExpressionFunctionTrackerHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMExpressionFunctionTracker.class})
public class DDMExpressionFunctionTrackerImpl
implements DDMExpressionFunctionTracker {
    protected DDMExpressionFunctionTrackerHelper ddmExpressionFunctionTrackerHelper = new DDMExpressionFunctionTrackerHelper();

    public Map<String, DDMExpressionFunction> getDDMExpressionFunctions(Set<String> functionNames) {
        HashMap<String, DDMExpressionFunction> ddmExpressionFunctionsMap = new HashMap<String, DDMExpressionFunction>(functionNames.size());
        for (String functionName : functionNames) {
            DDMExpressionFunction ddmExpressionFunction = this.ddmExpressionFunctionTrackerHelper.getDDMExpressionFunction(functionName);
            if (ddmExpressionFunction == null) continue;
            ddmExpressionFunctionsMap.put(functionName, ddmExpressionFunction);
        }
        return ddmExpressionFunctionsMap;
    }

    public void ungetDDMExpressionFunctions(Map<String, DDMExpressionFunction> ddmExpressionFunctionsMap) {
        for (Map.Entry<String, DDMExpressionFunction> entry : ddmExpressionFunctionsMap.entrySet()) {
            this.ddmExpressionFunctionTrackerHelper.ungetDDMExpressionFunction(entry.getValue());
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.factory=com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionFactory)", unbind="unsetComponentFactory")
    protected void addComponentFactory(ComponentFactory componentFactory) {
        this.ddmExpressionFunctionTrackerHelper.addComponentFactory(componentFactory);
    }

    @Deactivate
    protected void deactivate() {
        this.ddmExpressionFunctionTrackerHelper.clear();
    }

    protected void unsetComponentFactory(ComponentFactory componentFactory) {
        this.ddmExpressionFunctionTrackerHelper.removeComponentFactory(componentFactory);
    }
}

