/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandler;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionActionHandlerAware;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessorAware;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserverAware;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessorAware;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyResponse;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionBaseVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionParser;
import com.liferay.portal.kernel.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DDMExpressionEvaluatorVisitor
extends DDMExpressionBaseVisitor<Object> {
    private final DDMExpressionActionHandler _ddmExpressionActionHandler;
    private final DDMExpressionFieldAccessor _ddmExpressionFieldAccessor;
    private final Map<String, DDMExpressionFunction> _ddmExpressionFunctions;
    private final DDMExpressionObserver _ddmExpressionObserver;
    private final DDMExpressionParameterAccessor _ddmExpressionParameterAccessor;
    private final Map<String, Object> _variables;

    @Override
    public Object visitAdditionExpression(@NotNull DDMExpressionParser.AdditionExpressionContext context) {
        BigDecimal bigDecimal1 = (BigDecimal)this.visitChild(context, 0);
        BigDecimal bigDecimal2 = (BigDecimal)this.visitChild(context, 2);
        return bigDecimal1.add(bigDecimal2);
    }

    @Override
    public Object visitAndExpression(@NotNull DDMExpressionParser.AndExpressionContext context) {
        Boolean boolean1 = (Boolean)this.visitChild(context, 0);
        if (!boolean1.booleanValue()) {
            return Boolean.FALSE;
        }
        Boolean boolean2 = (Boolean)this.visitChild(context, 2);
        return boolean1 != false && boolean2 != false;
    }

    @Override
    public Object visitBooleanParenthesis(@NotNull DDMExpressionParser.BooleanParenthesisContext context) {
        return this.visitChild(context, 1);
    }

    @Override
    public Object visitDivisionExpression(@NotNull DDMExpressionParser.DivisionExpressionContext context) {
        BigDecimal bigDecimal1 = (BigDecimal)this.visitChild(context, 0);
        BigDecimal bigDecimal2 = (BigDecimal)this.visitChild(context, 2);
        if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0) {
            return "NaN";
        }
        return bigDecimal1.divide(bigDecimal2, 2, RoundingMode.FLOOR);
    }

    @Override
    public Object visitEqualsExpression(@NotNull DDMExpressionParser.EqualsExpressionContext context) {
        Object object1 = this.visitChild(context, 0);
        Object object2 = this.visitChild(context, 2);
        return Objects.equals(object1, object2);
    }

    @Override
    public Object visitExpression(@NotNull DDMExpressionParser.ExpressionContext context) {
        DDMExpressionParser.LogicalOrExpressionContext logicalOrExpressionContext = context.logicalOrExpression();
        return logicalOrExpressionContext.accept(this);
    }

    @Override
    public Object visitFloatingPointLiteral(@NotNull DDMExpressionParser.FloatingPointLiteralContext context) {
        return new BigDecimal(context.getText());
    }

    @Override
    public Object visitFunctionCallExpression(@NotNull DDMExpressionParser.FunctionCallExpressionContext context) {
        Object[] params;
        String functionName = this.getFunctionName(context.functionName);
        DDMExpressionFunction ddmExpressionFunction = this._ddmExpressionFunctions.get(functionName);
        if (ddmExpressionFunction instanceof DDMExpressionObserverAware) {
            ((DDMExpressionObserverAware)ddmExpressionFunction).setDDMExpressionObserver(this._ddmExpressionObserver);
        }
        if (ddmExpressionFunction instanceof DDMExpressionActionHandlerAware) {
            ((DDMExpressionActionHandlerAware)ddmExpressionFunction).setDDMExpressionActionHandler(this._ddmExpressionActionHandler);
        }
        if (ddmExpressionFunction instanceof DDMExpressionParameterAccessorAware) {
            ((DDMExpressionParameterAccessorAware)ddmExpressionFunction).setDDMExpressionParameterAccessor(this._ddmExpressionParameterAccessor);
        }
        if (ddmExpressionFunction instanceof DDMExpressionFieldAccessorAware) {
            ((DDMExpressionFieldAccessorAware)ddmExpressionFunction).setDDMExpressionFieldAccessor(this._ddmExpressionFieldAccessor);
        }
        if ((params = this.getFunctionParameters(context.functionParameters())).length == 0) {
            DDMExpressionFunction.Function0 function0 = (DDMExpressionFunction.Function0)ddmExpressionFunction;
            return function0.apply();
        }
        if (params.length == 1) {
            DDMExpressionFunction.Function1 function1 = (DDMExpressionFunction.Function1)ddmExpressionFunction;
            return function1.apply(params[0]);
        }
        if (params.length == 2) {
            DDMExpressionFunction.Function2 function2 = (DDMExpressionFunction.Function2)ddmExpressionFunction;
            return function2.apply(params[0], params[1]);
        }
        if (params.length == 3) {
            DDMExpressionFunction.Function3 function3 = (DDMExpressionFunction.Function3)ddmExpressionFunction;
            return function3.apply(params[0], params[1], params[2]);
        }
        if (params.length == 4) {
            DDMExpressionFunction.Function4 function4 = (DDMExpressionFunction.Function4)ddmExpressionFunction;
            return function4.apply(params[0], params[1], params[2], params[3]);
        }
        return null;
    }

    @Override
    public Object visitGreaterThanExpression(@NotNull DDMExpressionParser.GreaterThanExpressionContext context) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 0));
        return bigDecimal1.compareTo(bigDecimal2 = this.getBigDecimal((Comparable)this.visitChild(context, 2))) == 1;
    }

    @Override
    public Object visitGreaterThanOrEqualsExpression(@NotNull DDMExpressionParser.GreaterThanOrEqualsExpressionContext context) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 0));
        return bigDecimal1.compareTo(bigDecimal2 = this.getBigDecimal((Comparable)this.visitChild(context, 2))) >= 0;
    }

    @Override
    public Object visitIntegerLiteral(@NotNull DDMExpressionParser.IntegerLiteralContext context) {
        return new BigDecimal(context.getText());
    }

    @Override
    public Object visitLessThanExpression(@NotNull DDMExpressionParser.LessThanExpressionContext context) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 0));
        return bigDecimal1.compareTo(bigDecimal2 = this.getBigDecimal((Comparable)this.visitChild(context, 2))) == -1;
    }

    @Override
    public Object visitLessThanOrEqualsExpression(@NotNull DDMExpressionParser.LessThanOrEqualsExpressionContext context) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 0));
        return bigDecimal1.compareTo(bigDecimal2 = this.getBigDecimal((Comparable)this.visitChild(context, 2))) <= 0;
    }

    @Override
    public Object visitLogicalConstant(@NotNull DDMExpressionParser.LogicalConstantContext context) {
        return Boolean.parseBoolean(context.getText());
    }

    @Override
    public Object visitLogicalVariable(@NotNull DDMExpressionParser.LogicalVariableContext context) {
        String variable = context.getText();
        Object variableValue = this._variables.get(variable);
        if (variableValue == null && this._variables.size() > 1) {
            for (Map.Entry<String, Object> entry : this._variables.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!key.startsWith(variable) || value == null) continue;
                variableValue = value;
            }
        }
        if (variableValue == null && this._ddmExpressionFieldAccessor.isField(variable)) {
            GetFieldPropertyRequest.Builder builder = GetFieldPropertyRequest.Builder.newBuilder((String)variable, (String)"value");
            GetFieldPropertyResponse getFieldPropertyResponse = this._ddmExpressionFieldAccessor.getFieldProperty(builder.build());
            variableValue = getFieldPropertyResponse.getValue();
        }
        if (variableValue == null) {
            throw new IllegalStateException(String.format("Variable \"%s\" not defined", variable));
        }
        return variableValue;
    }

    @Override
    public Object visitMinusExpression(@NotNull DDMExpressionParser.MinusExpressionContext context) {
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 1));
        return bigDecimal1.multiply(new BigDecimal(-1));
    }

    @Override
    public Object visitMultiplicationExpression(@NotNull DDMExpressionParser.MultiplicationExpressionContext context) {
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 0));
        BigDecimal bigDecimal2 = this.getBigDecimal((Comparable)this.visitChild(context, 2));
        return bigDecimal1.multiply(bigDecimal2);
    }

    @Override
    public Object visitNotEqualsExpression(@NotNull DDMExpressionParser.NotEqualsExpressionContext context) {
        Object object2;
        Object object1 = this.visitChild(context, 0);
        return !Objects.equals(object1, object2 = this.visitChild(context, 2));
    }

    @Override
    public Object visitNotExpression(@NotNull DDMExpressionParser.NotExpressionContext context) {
        boolean boolean1 = (Boolean)this.visitChild(context, 1);
        return !boolean1;
    }

    @Override
    public Object visitNumericParenthesis(@NotNull DDMExpressionParser.NumericParenthesisContext context) {
        return this.visitChild(context, 1);
    }

    @Override
    public Object visitNumericVariable(@NotNull DDMExpressionParser.NumericVariableContext context) {
        String variable = context.getText();
        Object variableValue = this._variables.get(variable);
        if (variableValue == null && this._ddmExpressionFieldAccessor.isField(variable)) {
            GetFieldPropertyRequest.Builder builder = GetFieldPropertyRequest.Builder.newBuilder((String)variable, (String)"value");
            GetFieldPropertyResponse getFieldPropertyResponse = this._ddmExpressionFieldAccessor.getFieldProperty(builder.build());
            variableValue = getFieldPropertyResponse.getValue();
        }
        if (variableValue == null) {
            throw new IllegalStateException(String.format("variable %s not defined", variable));
        }
        return variableValue;
    }

    @Override
    public Object visitOrExpression(@NotNull DDMExpressionParser.OrExpressionContext context) {
        boolean boolean1 = (Boolean)this.visitChild(context, 0);
        if (boolean1) {
            return Boolean.TRUE;
        }
        boolean boolean2 = (Boolean)this.visitChild(context, 2);
        return boolean1 || boolean2;
    }

    @Override
    public Object visitStringLiteral(@NotNull DDMExpressionParser.StringLiteralContext context) {
        return StringUtil.unquote((String)context.getText());
    }

    @Override
    public Object visitSubtractionExpression(@NotNull DDMExpressionParser.SubtractionExpressionContext context) {
        BigDecimal bigDecimal1 = this.getBigDecimal((Comparable)this.visitChild(context, 0));
        BigDecimal bigDecimal2 = this.getBigDecimal((Comparable)this.visitChild(context, 2));
        return bigDecimal1.subtract(bigDecimal2);
    }

    @Override
    public Object visitToFloatingPointArray(DDMExpressionParser.ToFloatingPointArrayContext context) {
        List<TerminalNode> floatingPointLiteralTerminalNodes = context.FloatingPointLiteral();
        Stream stream = floatingPointLiteralTerminalNodes.stream();
        return stream.map(floatingPoint -> new BigDecimal(floatingPoint.getText())).toArray(BigDecimal[]::new);
    }

    @Override
    public Object visitToIntegerArray(DDMExpressionParser.ToIntegerArrayContext context) {
        List<TerminalNode> integerLiteralTerminalNodes = context.IntegerLiteral();
        Stream stream = integerLiteralTerminalNodes.stream();
        return stream.map(integerLiteral -> new BigDecimal(integerLiteral.getText())).toArray(BigDecimal[]::new);
    }

    @Override
    public Object visitToStringArray(DDMExpressionParser.ToStringArrayContext context) {
        List<TerminalNode> stringTerminalNodes = context.STRING();
        Stream stream = stringTerminalNodes.stream();
        return stream.map(floatingPoint -> StringUtil.unquote((String)floatingPoint.getText())).toArray(String[]::new);
    }

    protected DDMExpressionEvaluatorVisitor(Map<String, DDMExpressionFunction> ddmExpressionFunctions, Map<String, Object> variables, DDMExpressionActionHandler ddmExpressionActionHandler, DDMExpressionFieldAccessor ddmExpressionFieldAccessor, DDMExpressionObserver ddmExpressionObserver, DDMExpressionParameterAccessor ddmExpressionParameterAccessor) {
        this._ddmExpressionFunctions = ddmExpressionFunctions;
        this._variables = variables;
        this._ddmExpressionActionHandler = ddmExpressionActionHandler;
        this._ddmExpressionFieldAccessor = ddmExpressionFieldAccessor;
        this._ddmExpressionObserver = ddmExpressionObserver;
        this._ddmExpressionParameterAccessor = ddmExpressionParameterAccessor;
    }

    protected BigDecimal getBigDecimal(Comparable<?> comparable) {
        if (comparable instanceof BigDecimal) {
            return (BigDecimal)comparable;
        }
        return new BigDecimal(comparable.toString());
    }

    protected String getFunctionName(Token functionNameToken) {
        return functionNameToken.getText();
    }

    protected Object[] getFunctionParameters(DDMExpressionParser.FunctionParametersContext context) {
        if (context == null) {
            return new Object[0];
        }
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < context.getChildCount(); i += 2) {
            Object parameter = this.visitChild(context, i);
            parameters.add(parameter);
        }
        return parameters.toArray(new Object[0]);
    }

    protected <T> T visitChild(ParserRuleContext parserRuleContext, int childIndex) {
        ParseTree parseTree = parserRuleContext.getChild(childIndex);
        return (T)parseTree.accept(this);
    }
}

