/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.data.provider.instance.id=getDataProviderInstances"}, service={DDMDataProvider.class})
public class DDMDataProviderInstancesDataProvider
implements DDMDataProvider {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInstancesDataProvider.class);
    @Reference
    private DDMDataProviderInstanceLocalService _ddmDataProviderInstanceLocalService;
    @Reference
    private Portal _portal;

    public List<KeyValuePair> getData(DDMDataProviderContext ddmDataProviderContext) throws DDMDataProviderException {
        return Collections.emptyList();
    }

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        ArrayList<KeyValuePair> data;
        block4: {
            data = new ArrayList<KeyValuePair>();
            try {
                HttpServletRequest request = ddmDataProviderRequest.getHttpServletRequest();
                long scopeGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"scopeGroupId");
                if (scopeGroupId == 0L) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    scopeGroupId = themeDisplay.getScopeGroupId();
                }
                long[] groupIds = this._portal.getCurrentAndAncestorSiteGroupIds(scopeGroupId);
                List ddmDataProviderInstances = this._ddmDataProviderInstanceLocalService.getDataProviderInstances(groupIds);
                for (DDMDataProviderInstance ddmDataProviderInstance : ddmDataProviderInstances) {
                    long value = ddmDataProviderInstance.getDataProviderInstanceId();
                    String label = ddmDataProviderInstance.getName(LocaleThreadLocal.getThemeDisplayLocale());
                    data.add(new KeyValuePair(String.valueOf(value), label));
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])new DDMDataProviderResponseOutput[]{DDMDataProviderResponseOutput.of((String)"Default-Output", (String)"list", data)});
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

