/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderOutputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderParameterSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormInstanceFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.data.provider.instance.id=getDataProviderInstanceOutputParameters"}, service={DDMDataProvider.class})
public class DDMDataProviderInstanceOutputParametersDataProvider
implements DDMDataProvider {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInstanceOutputParametersDataProvider.class);
    @Reference
    private DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    @Reference
    private DDMDataProviderTracker _ddmDataProviderTracker;
    @Reference
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;

    public List<KeyValuePair> getData(DDMDataProviderContext ddmDataProviderContext) throws DDMDataProviderException {
        return Collections.emptyList();
    }

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        long dataProviderInstanceId = GetterUtil.getLong((String)ddmDataProviderRequest.getParameter("dataProviderInstanceId"));
        if (dataProviderInstanceId == 0L) {
            return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])new DDMDataProviderResponseOutput[0]);
        }
        ArrayList<KeyValuePair> data = new ArrayList<KeyValuePair>();
        try {
            DDMDataProviderOutputParametersSettings[] ddmDataProviderOutputParametersSettings;
            for (DDMDataProviderOutputParametersSettings ddmDataProviderOutputParametersSetting : ddmDataProviderOutputParametersSettings = this.getDDMDataProviderOutputParametersSettings(dataProviderInstanceId)) {
                String outputParameterName = ddmDataProviderOutputParametersSetting.outputParameterName();
                data.add(new KeyValuePair(outputParameterName, outputParameterName));
            }
        }
        catch (Exception e) {
            _log.error((Object)String.format("Unable to get the output parameters for data provider instance with id '%d'", dataProviderInstanceId), (Throwable)e);
        }
        return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])new DDMDataProviderResponseOutput[]{DDMDataProviderResponseOutput.of((String)"outputParameterNames", (String)"list", data)});
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }

    protected DDMFormValues getDataProviderInstanceFormValues(DDMDataProvider ddmDataProvider, DDMDataProviderInstance ddmDataProviderInstance) throws PortalException {
        DDMForm ddmForm = DDMFormFactory.create((Class)ddmDataProvider.getSettings());
        return this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, ddmDataProviderInstance.getDefinition());
    }

    protected DDMDataProviderOutputParametersSettings[] getDDMDataProviderOutputParametersSettings(long dataProviderInstanceId) throws Exception {
        DDMDataProviderInstance ddmDataProviderInstance = this._ddmDataProviderInstanceService.getDataProviderInstance(dataProviderInstanceId);
        DDMDataProvider ddmDataProvider = this._ddmDataProviderTracker.getDDMDataProvider(ddmDataProviderInstance.getType());
        if (!ClassUtil.isSubclass((Class)ddmDataProvider.getSettings(), DDMDataProviderParameterSettings.class)) {
            return new DDMDataProviderOutputParametersSettings[0];
        }
        DDMFormValues dataProviderFormValues = this.getDataProviderInstanceFormValues(ddmDataProvider, ddmDataProviderInstance);
        DDMDataProviderParameterSettings ddmDataProviderParameterSetting = (DDMDataProviderParameterSettings)DDMFormInstanceFactory.create(DDMDataProviderParameterSettings.class, (DDMFormValues)dataProviderFormValues);
        return ddmDataProviderParameterSetting.outputParameters();
    }
}

