/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal.rest;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInstanceSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderOutputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseStatus;
import com.liferay.dynamic.data.mapping.data.provider.internal.rest.DDMRESTDataProviderSettings;
import com.liferay.dynamic.data.mapping.data.provider.settings.DDMDataProviderSettingsProvider;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpException;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.data.provider.type=rest"}, service={DDMDataProvider.class})
public class DDMRESTDataProvider
implements DDMDataProvider {
    @Reference
    protected DDMDataProviderInstanceService ddmDataProviderInstanceService;
    @Reference
    protected DDMDataProviderInstanceSettings ddmDataProviderInstanceSettings;
    @Reference(target="(ddm.data.provider.type=rest)")
    protected DDMDataProviderSettingsProvider ddmDataProviderSettingsProvider;
    @Reference
    protected Http http;
    @Reference
    protected Portal portal;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMRESTDataProvider.class);
    private static final Pattern _pathParameterPattern = Pattern.compile("\\{(.+?)\\}");
    private PortalCache<String, DDMDataProviderResponse> _portalCache;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        try {
            return this.doGetData(ddmDataProviderRequest);
        }
        catch (HttpException httpException) {
            Throwable throwable = httpException.getCause();
            if (throwable instanceof ConnectException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)throwable, throwable);
                }
                DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
                return builder.withStatus(DDMDataProviderResponseStatus.SERVICE_UNAVAILABLE).build();
            }
            throw new DDMDataProviderException((Throwable)httpException);
        }
        catch (Exception exception) {
            throw new DDMDataProviderException((Throwable)exception);
        }
    }

    public Class<?> getSettings() {
        return this.ddmDataProviderSettingsProvider.getSettings();
    }

    protected String buildURL(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map<String, String> pathParameters = this.getPathParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        String url = ddmRESTDataProviderSettings.url();
        for (Map.Entry<String, String> pathParameter : pathParameters.entrySet()) {
            url = StringUtil.replaceFirst((String)url, (String)String.format("{%s}", pathParameter.getKey()), (String)HtmlUtil.escapeURL((String)pathParameter.getValue()));
        }
        return url;
    }

    protected DDMDataProviderResponse createDDMDataProviderResponse(DocumentContext documentContext, DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        DDMDataProviderOutputParametersSettings[] outputParameterSettingsArray = ddmRESTDataProviderSettings.outputParameters();
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        if (outputParameterSettingsArray == null || outputParameterSettingsArray.length == 0) {
            return builder.build();
        }
        for (DDMDataProviderOutputParametersSettings outputParameterSettings : outputParameterSettingsArray) {
            String normalizedValuePath;
            Object value;
            String id = outputParameterSettings.outputParameterId();
            String type = outputParameterSettings.outputParameterType();
            String path = outputParameterSettings.outputParameterPath();
            if (Objects.equals(type, "text")) {
                value = (String)documentContext.read(this.normalizePath(path), String.class, new Predicate[0]);
                builder = builder.withOutput(id, value);
                continue;
            }
            if (Objects.equals(type, "number")) {
                value = (Number)documentContext.read(this.normalizePath(path), Number.class, new Predicate[0]);
                builder = builder.withOutput(id, value);
                continue;
            }
            if (!Objects.equals(type, "list")) continue;
            String[] paths = StringUtil.split((String)path, (char)';');
            String normalizedKeyPath = normalizedValuePath = this.normalizePath(paths[0]);
            List values = (List)documentContext.read(normalizedValuePath, List.class, new Predicate[0]);
            if (values == null) continue;
            List keys = new ArrayList(values);
            if (paths.length >= 2) {
                normalizedKeyPath = this.normalizePath(paths[1]);
                keys = (List)documentContext.read(normalizedKeyPath, new Predicate[0]);
            }
            ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
            for (int i = 0; i < values.size(); ++i) {
                keyValuePairs.add(new KeyValuePair((String)keys.get(i), (String)values.get(i)));
            }
            if (ddmRESTDataProviderSettings.pagination()) {
                Optional paginationStartOptional = ddmDataProviderRequest.getParameterOptional("paginationStart", String.class);
                int start = Integer.valueOf(paginationStartOptional.orElse("1"));
                Optional paginationEndOptional = ddmDataProviderRequest.getParameterOptional("paginationEnd", String.class);
                int end = Integer.valueOf(paginationEndOptional.orElse("10"));
                if (keyValuePairs.size() <= end - start) continue;
                List sublist = ListUtil.subList(keyValuePairs, (int)start, (int)end);
                builder = builder.withOutput(id, (Object)sublist);
                continue;
            }
            builder = builder.withOutput(id, keyValuePairs);
        }
        return builder.build();
    }

    protected DDMDataProviderResponse doGetData(DDMDataProviderRequest ddmDataProviderRequest) throws Exception {
        Optional<DDMDataProviderInstance> ddmDataProviderInstance = this.fetchDDMDataProviderInstance(ddmDataProviderRequest.getDDMDataProviderId());
        if (!ddmDataProviderInstance.isPresent()) {
            DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
            return builder.withStatus(DDMDataProviderResponseStatus.SERVICE_UNAVAILABLE).build();
        }
        DDMRESTDataProviderSettings ddmRESTDataProviderSettings = (DDMRESTDataProviderSettings)this.ddmDataProviderInstanceSettings.getSettings(ddmDataProviderInstance.get(), DDMRESTDataProviderSettings.class);
        HttpRequest httpRequest = HttpRequest.get((String)this.buildURL(ddmDataProviderRequest, ddmRESTDataProviderSettings));
        if (StringUtil.startsWith((String)ddmRESTDataProviderSettings.url(), (String)"https")) {
            httpRequest.trustAllCerts(true);
        }
        if (Validator.isNotNull((String)ddmRESTDataProviderSettings.username())) {
            httpRequest.basicAuthentication(ddmRESTDataProviderSettings.username(), ddmRESTDataProviderSettings.password());
        }
        this.setRequestParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings, httpRequest);
        String cacheKey = this.getCacheKey(httpRequest);
        DDMDataProviderResponse ddmDataProviderResponse = (DDMDataProviderResponse)this._portalCache.get((Serializable)((Object)cacheKey));
        if (ddmDataProviderResponse != null && ddmRESTDataProviderSettings.cacheable()) {
            return ddmDataProviderResponse;
        }
        HttpResponse httpResponse = null;
        Map<String, Object> proxySettings = this.getProxySettings();
        if (this.isNonproxiedHttpRequest(httpRequest, proxySettings)) {
            httpResponse = httpRequest.send();
        } else {
            SocketHttpConnectionProvider socketHttpConnectionProvider = new SocketHttpConnectionProvider();
            String proxyAddress = GetterUtil.getString((Object)proxySettings.get("proxyAddress"));
            int proxyPort = GetterUtil.getInteger((Object)proxySettings.get("proxyPort"));
            socketHttpConnectionProvider.useProxy(ProxyInfo.httpProxy((String)proxyAddress, (int)proxyPort, null, null));
            HttpRequest proxiedHttpRequest = httpRequest.withConnectionProvider((HttpConnectionProvider)socketHttpConnectionProvider);
            httpResponse = proxiedHttpRequest.send();
        }
        httpResponse.charset("UTF-8");
        String responseBodyText = this._removeUTFBOM(httpResponse.bodyText());
        DocumentContext documentContext = JsonPath.parse((String)responseBodyText);
        ddmDataProviderResponse = this.createDDMDataProviderResponse(documentContext, ddmDataProviderRequest, ddmRESTDataProviderSettings);
        if (ddmRESTDataProviderSettings.cacheable()) {
            this._portalCache.put((Serializable)((Object)cacheKey), (Object)ddmDataProviderResponse);
        }
        return ddmDataProviderResponse;
    }

    protected Optional<DDMDataProviderInstance> fetchDDMDataProviderInstance(String ddmDataProviderInstanceId) throws PortalException {
        DDMDataProviderInstance ddmDataProviderInstance = this.ddmDataProviderInstanceService.fetchDataProviderInstanceByUuid(ddmDataProviderInstanceId);
        if (ddmDataProviderInstance == null && Validator.isNumber((String)ddmDataProviderInstanceId)) {
            ddmDataProviderInstance = this.ddmDataProviderInstanceService.fetchDataProviderInstance(Long.valueOf(ddmDataProviderInstanceId).longValue());
        }
        return Optional.ofNullable(ddmDataProviderInstance);
    }

    protected String getCacheKey(HttpRequest httpRequest) {
        return httpRequest.url();
    }

    protected Map<String, Object> getParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map parameters = ddmDataProviderRequest.getParameters();
        Stream<DDMDataProviderInputParametersSettings> stream = Arrays.stream(ddmRESTDataProviderSettings.inputParameters());
        return stream.filter(inputParameter -> parameters.containsKey(inputParameter.inputParameterName())).collect(Collectors.toMap(DDMDataProviderInputParametersSettings::inputParameterName, value -> parameters.get(value.inputParameterName())));
    }

    protected Map<String, String> getPathParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map<String, Object> parameters = this.getParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        Matcher matcher = _pathParameterPattern.matcher(ddmRESTDataProviderSettings.url());
        while (matcher.find()) {
            String parameterName = matcher.group(1);
            if (!parameters.containsKey(parameterName)) continue;
            pathParameters.put(parameterName, GetterUtil.getString((Object)parameters.get(parameterName)));
        }
        return pathParameters;
    }

    protected Map<String, Object> getProxySettings() {
        HashMap<String, Object> proxySettings;
        block3: {
            proxySettings = new HashMap<String, Object>();
            try {
                String proxyAddress = SystemProperties.get((String)"http.proxyHost");
                String proxyPort = SystemProperties.get((String)"http.proxyPort");
                if (Validator.isNotNull((String)proxyAddress) && Validator.isNotNull((String)proxyPort)) {
                    proxySettings.put("proxyAddress", proxyAddress);
                    proxySettings.put("proxyPort", Integer.valueOf(proxyPort));
                }
            }
            catch (Exception exception) {
                proxySettings.clear();
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to get proxy settings from system properties", (Throwable)exception);
            }
        }
        return proxySettings;
    }

    protected Map<String, String> getQueryParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map<String, String> pathParameters = this.getPathParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        Map<String, Object> parametersMap = this.getParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        Set<Map.Entry<String, Object>> entrySet = parametersMap.entrySet();
        HashMap<String, String> parameters = new HashMap<String, String>();
        entrySet.forEach(entry -> {
            String key = (String)entry.getKey();
            if (!pathParameters.containsKey(key)) {
                parameters.put(key, String.valueOf(entry.getValue()));
            }
        });
        return parameters;
    }

    protected boolean isNonproxiedHttpRequest(HttpRequest httpRequest, Map<String, Object> proxySettings) {
        return proxySettings.isEmpty() || proxySettings.get("proxyAddress") == null || this.http.isNonProxyHost(httpRequest.host());
    }

    protected String normalizePath(String path) {
        if (StringUtil.startsWith((String)path, (String)"$") || StringUtil.startsWith((String)path, (String)".") || StringUtil.startsWith((String)path, (String)"*")) {
            return path;
        }
        return ".".concat(path);
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        this._portalCache = multiVMPool.getPortalCache(DDMRESTDataProvider.class.getName());
    }

    protected void setRequestParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings, HttpRequest httpRequest) {
        Optional filterParameterValue;
        if (ddmRESTDataProviderSettings.filterable() && (filterParameterValue = ddmDataProviderRequest.getParameterOptional("filterParameterValue", String.class)).isPresent()) {
            httpRequest.query(ddmRESTDataProviderSettings.filterParameterName(), (String)filterParameterValue.get());
        }
        if (ddmRESTDataProviderSettings.pagination()) {
            Optional paginationEnd;
            Optional paginationStart = ddmDataProviderRequest.getParameterOptional("paginationStart", String.class);
            if (paginationStart.isPresent()) {
                httpRequest.query(ddmRESTDataProviderSettings.paginationStartParameterName(), (String)paginationStart.get());
            }
            if ((paginationEnd = ddmDataProviderRequest.getParameterOptional("paginationEnd", String.class)).isPresent()) {
                httpRequest.query(ddmRESTDataProviderSettings.paginationEndParameterName(), (String)paginationEnd.get());
            }
        }
        httpRequest.query(this.getQueryParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings));
    }

    private String _removeUTFBOM(String bodyText) {
        for (int i = 0; i < bodyText.length(); ++i) {
            if (bodyText.charAt(i) != '[' && bodyText.charAt(i) != '{') continue;
            return bodyText.substring(i);
        }
        return "";
    }
}

