/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInstanceSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInvoker;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseStatus;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.data.provider.internal.DDMDataProviderInvokeCommand;
import com.liferay.dynamic.data.mapping.data.provider.internal.rest.DDMRESTDataProviderSettings;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.Validator;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMDataProviderInvoker.class})
public class DDMDataProviderInvokerImpl
implements DDMDataProviderInvoker {
    @Reference
    protected DDMDataProviderInstanceService ddmDataProviderInstanceService;
    @Reference
    protected DDMDataProviderInstanceSettings ddmDataProviderInstanceSettings;
    @Reference
    protected DDMDataProviderTracker ddmDataProviderTracker;
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInvokerImpl.class);

    public DDMDataProviderResponse invoke(DDMDataProviderRequest ddmDataProviderRequest) {
        try {
            return this.doInvoke(ddmDataProviderRequest);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to invoke DDM Data Provider instance ID " + ddmDataProviderRequest.getDDMDataProviderId()), (Throwable)e);
            }
            return this.createDDMDataProviderErrorResponse(e);
        }
    }

    protected DDMDataProviderResponse createDDMDataProviderErrorResponse(Exception e) {
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        if (e instanceof HystrixRuntimeException) {
            HystrixRuntimeException.FailureType failureType = this.getHystrixFailureType(e);
            if (failureType == HystrixRuntimeException.FailureType.COMMAND_EXCEPTION) {
                builder = builder.withStatus(DDMDataProviderResponseStatus.COMMAND_EXCEPTION);
            } else if (failureType == HystrixRuntimeException.FailureType.SHORTCIRCUIT) {
                builder = builder.withStatus(DDMDataProviderResponseStatus.SHORT_CIRCUIT);
            } else if (failureType == HystrixRuntimeException.FailureType.TIMEOUT) {
                builder = builder.withStatus(DDMDataProviderResponseStatus.TIMEOUT);
            }
        } else {
            builder = e instanceof PrincipalException ? builder.withStatus(DDMDataProviderResponseStatus.UNAUTHORIZED) : builder.withStatus(DDMDataProviderResponseStatus.UNKNOWN_ERROR);
        }
        return builder.build();
    }

    protected DDMDataProviderResponse doInvoke(DDMDataProviderRequest ddmDataProviderRequest) throws Exception {
        String ddmDataProviderId = ddmDataProviderRequest.getDDMDataProviderId();
        Optional<DDMDataProviderInstance> ddmDataProviderInstanceOptional = this.fetchDDMDataProviderInstanceOptional(ddmDataProviderId);
        DDMDataProvider ddmDataProvider = this.getDDMDataProvider(ddmDataProviderId, ddmDataProviderInstanceOptional);
        if (ddmDataProviderInstanceOptional.isPresent()) {
            return this.doInvokeExternal(ddmDataProviderInstanceOptional.get(), ddmDataProvider, ddmDataProviderRequest);
        }
        return ddmDataProvider.getData(ddmDataProviderRequest);
    }

    protected DDMDataProviderResponse doInvokeExternal(DDMDataProviderInstance ddmDataProviderInstance, DDMDataProvider ddmDataProvider, DDMDataProviderRequest ddmDataProviderRequest) {
        DDMDataProviderInvokeCommand ddmDataProviderInvokeCommand = new DDMDataProviderInvokeCommand(ddmDataProviderInstance.getNameCurrentValue(), ddmDataProvider, ddmDataProviderRequest, (DDMRESTDataProviderSettings)this.ddmDataProviderInstanceSettings.getSettings(ddmDataProviderInstance, DDMRESTDataProviderSettings.class));
        return (DDMDataProviderResponse)ddmDataProviderInvokeCommand.execute();
    }

    protected Optional<DDMDataProviderInstance> fetchDDMDataProviderInstanceOptional(String ddmDataProviderInstanceId) throws PortalException {
        DDMDataProviderInstance ddmDataProviderInstance = this.ddmDataProviderInstanceService.fetchDataProviderInstanceByUuid(ddmDataProviderInstanceId);
        if (ddmDataProviderInstance == null && Validator.isNumber((String)ddmDataProviderInstanceId)) {
            ddmDataProviderInstance = this.ddmDataProviderInstanceService.fetchDataProviderInstance(Long.valueOf(ddmDataProviderInstanceId).longValue());
        }
        return Optional.ofNullable(ddmDataProviderInstance);
    }

    protected DDMDataProvider getDDMDataProvider(String ddmDataProviderInstanceId, Optional<DDMDataProviderInstance> ddmDataProviderInstanceOptional) {
        Optional<DDMDataProvider> ddmDataProviderTypeOptional = ddmDataProviderInstanceOptional.map(ddmDataProviderInstance -> this.ddmDataProviderTracker.getDDMDataProvider(ddmDataProviderInstance.getType()));
        return ddmDataProviderTypeOptional.orElseGet(() -> this.ddmDataProviderTracker.getDDMDataProviderByInstanceId(ddmDataProviderInstanceId));
    }

    protected HystrixRuntimeException.FailureType getHystrixFailureType(Exception e) {
        HystrixRuntimeException hystrixRuntimeException = (HystrixRuntimeException)e;
        return hystrixRuntimeException.getFailureType();
    }
}

