/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContextContributor;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInvoker;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.data.provider.internal.DDMDataProviderInvokeCommand;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.Validator;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMDataProviderInvokerImpl
implements DDMDataProviderInvoker {
    @Reference
    protected DDMDataProviderInstanceService ddmDataProviderInstanceService;
    @Reference
    protected DDMDataProviderTracker ddmDataProviderTracker;
    @Reference
    protected DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer;
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInvokerImpl.class);

    public DDMDataProviderResponse invoke(DDMDataProviderRequest ddmDataProviderRequest) {
        try {
            return this.doInvoke(ddmDataProviderRequest);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to invoke DDM Data Provider instance ID " + ddmDataProviderRequest.getDDMDataProviderInstanceId()), (Throwable)e);
            }
            return this.createDDMDataProviderErrorResponse(e);
        }
    }

    protected void addDDMDataProviderRequestParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMDataProviderInstance ddmDataProviderInstance) {
        List ddmDataProviderContextContributors = this.ddmDataProviderTracker.getDDMDataProviderContextContributors(ddmDataProviderInstance.getType());
        for (DDMDataProviderContextContributor ddmDataProviderContextContributor : ddmDataProviderContextContributors) {
            Map parameters = ddmDataProviderContextContributor.getParameters(ddmDataProviderRequest.getHttpServletRequest());
            if (parameters == null) continue;
            ddmDataProviderRequest.queryString(parameters);
        }
    }

    protected DDMDataProviderContext createDDMDataProviderContext(DDMDataProviderInstance ddmDataProviderInstance) {
        try {
            DDMDataProvider ddmDataProvider = this.ddmDataProviderTracker.getDDMDataProvider(ddmDataProviderInstance.getType());
            DDMForm ddmForm = DDMFormFactory.create((Class)ddmDataProvider.getSettings());
            DDMFormValues ddmFormValues = this.ddmFormValuesJSONDeserializer.deserialize(ddmForm, ddmDataProviderInstance.getDefinition());
            return new DDMDataProviderContext(ddmFormValues);
        }
        catch (PortalException pe) {
            throw new IllegalStateException(pe);
        }
    }

    protected DDMDataProviderResponse createDDMDataProviderErrorResponse(Exception e) {
        if (e instanceof HystrixRuntimeException) {
            HystrixRuntimeException.FailureType failureType = this.getHystrixFailureType(e);
            if (failureType == HystrixRuntimeException.FailureType.TIMEOUT) {
                return DDMDataProviderResponse.error((DDMDataProviderResponse.Status)DDMDataProviderResponse.Status.TIMEOUT);
            }
            if (failureType == HystrixRuntimeException.FailureType.SHORTCIRCUIT) {
                return DDMDataProviderResponse.error((DDMDataProviderResponse.Status)DDMDataProviderResponse.Status.SHORTCIRCUIT);
            }
        } else if (e instanceof PrincipalException) {
            return DDMDataProviderResponse.error((DDMDataProviderResponse.Status)DDMDataProviderResponse.Status.UNAUTHORIZED);
        }
        return DDMDataProviderResponse.error((DDMDataProviderResponse.Status)DDMDataProviderResponse.Status.UNKNOWN_ERROR);
    }

    protected DDMDataProviderResponse doInvoke(DDMDataProviderRequest ddmDataProviderRequest) throws Exception {
        String ddmDataProviderInstanceId = ddmDataProviderRequest.getDDMDataProviderInstanceId();
        Optional<DDMDataProviderInstance> ddmDataProviderInstanceOptional = this.fetchDDMDataProviderInstance(ddmDataProviderInstanceId);
        this.setDDMDataProviderRequestAttributes(ddmDataProviderRequest, ddmDataProviderInstanceOptional);
        DDMDataProvider ddmDataProvider = this.getDDMDataProvider(ddmDataProviderInstanceId, ddmDataProviderInstanceOptional);
        if (ddmDataProviderInstanceOptional.isPresent()) {
            return this.doInvokeExternal(ddmDataProviderInstanceOptional.get(), ddmDataProvider, ddmDataProviderRequest);
        }
        return ddmDataProvider.getData(ddmDataProviderRequest);
    }

    protected DDMDataProviderResponse doInvokeExternal(DDMDataProviderInstance ddmDataProviderInstance, DDMDataProvider ddmDataProvider, DDMDataProviderRequest ddmDataProviderRequest) {
        DDMDataProviderInvokeCommand ddmDataProviderInvokeCommand = new DDMDataProviderInvokeCommand(ddmDataProviderInstance.getNameCurrentValue(), ddmDataProvider, ddmDataProviderRequest);
        return (DDMDataProviderResponse)ddmDataProviderInvokeCommand.execute();
    }

    protected Optional<DDMDataProviderInstance> fetchDDMDataProviderInstance(String ddmDataProviderInstanceId) throws PortalException {
        DDMDataProviderInstance ddmDataProviderInstance = this.ddmDataProviderInstanceService.fetchDataProviderInstanceByUuid(ddmDataProviderInstanceId);
        if (ddmDataProviderInstance == null && Validator.isNumber((String)ddmDataProviderInstanceId)) {
            ddmDataProviderInstance = this.ddmDataProviderInstanceService.fetchDataProviderInstance(Long.valueOf(ddmDataProviderInstanceId).longValue());
        }
        return Optional.ofNullable(ddmDataProviderInstance);
    }

    protected DDMDataProvider getDDMDataProvider(String ddmDataProviderInstanceId, Optional<DDMDataProviderInstance> ddmDataProviderInstanceOptional) {
        Optional<DDMDataProvider> ddmDataProviderTypeOptional = ddmDataProviderInstanceOptional.map(ddmDataProviderInstance -> this.ddmDataProviderTracker.getDDMDataProvider(ddmDataProviderInstance.getType()));
        return ddmDataProviderTypeOptional.orElseGet(() -> this.ddmDataProviderTracker.getDDMDataProviderByInstanceId(ddmDataProviderInstanceId));
    }

    protected HystrixRuntimeException.FailureType getHystrixFailureType(Exception e) {
        HystrixRuntimeException hystrixRuntimeException = (HystrixRuntimeException)e;
        return hystrixRuntimeException.getFailureType();
    }

    protected void setDDMDataProviderRequestAttributes(DDMDataProviderRequest ddmDataProviderRequest, Optional<DDMDataProviderInstance> ddmDataProviderInstanceOptional) {
        ddmDataProviderInstanceOptional.ifPresent(ddmDataProviderInstance -> {
            this.addDDMDataProviderRequestParameters(ddmDataProviderRequest, (DDMDataProviderInstance)ddmDataProviderInstance);
            this.setDDMDataProviderRequestContext(ddmDataProviderRequest, (DDMDataProviderInstance)ddmDataProviderInstance);
        });
    }

    protected void setDDMDataProviderRequestContext(DDMDataProviderRequest ddmDataProviderRequest, DDMDataProviderInstance ddmDataProviderInstance) {
        DDMDataProviderContext ddmDataProviderContext = this.createDDMDataProviderContext(ddmDataProviderInstance);
        ddmDataProviderRequest.setDDMDataProviderContext(ddmDataProviderContext);
        ddmDataProviderContext.addParameters(ddmDataProviderRequest.getParameters());
    }
}

