/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.change.tracking.internal.configuration;

import com.liferay.change.tracking.configuration.CTConfigurationRegistrar;
import com.liferay.change.tracking.configuration.builder.CTConfigurationBuilder;
import com.liferay.change.tracking.function.CTFunctions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureModel;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersionModel;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(immediate=true, service={})
public class DDMStructureCTConfigurationRegistrar {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureCTConfigurationRegistrar.class);
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private CTConfigurationBuilder<DDMStructure, DDMStructureVersion> _builder;
    @Reference
    private CTConfigurationRegistrar _ctConfigurationRegistrar;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    @Activate
    public void activate() {
        this._ctConfigurationRegistrar.register(this._builder.setContentType("Dynamic Data Mapping Structure").setContentTypeLanguageKey("dynamic-data-mapping-structure").setEntityClasses(DDMStructure.class, DDMStructureVersion.class).setResourceEntitiesByCompanyIdFunction(this::_fetchDDMStructures).setResourceEntityByResourceEntityIdFunction(arg_0 -> ((DDMStructureLocalService)this._ddmStructureLocalService).fetchStructure(arg_0)).setEntityIdsFromResourceEntityFunctions(DDMStructureModel::getStructureId, this::_fetchLatestStructureVersionId).setVersionEntitiesFromResourceEntityFunction(ddmStructure -> this._ddmStructureVersionLocalService.getStructureVersions(ddmStructure.getStructureId())).setVersionEntityByVersionEntityIdFunction(arg_0 -> ((DDMStructureVersionLocalService)this._ddmStructureVersionLocalService).fetchDDMStructureVersion(arg_0)).setVersionEntityDetails(null, CTFunctions.getFetchSiteNameFunction(), ddmStructureVersion -> ddmStructureVersion.getName(LocaleUtil.getMostRelevantLocale()), DDMStructureVersionModel::getVersion).setEntityIdsFromVersionEntityFunctions(DDMStructureVersionModel::getStructureId, DDMStructureVersionModel::getStructureVersionId).setVersionEntityStatusInfo(new Integer[]{0, 2}, DDMStructureVersionModel::getStatus).build());
    }

    private List<DDMStructure> _fetchDDMStructures(long companyId) {
        DynamicQuery dynamicQuery = this._ddmStructureLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        return this._ddmStructureLocalService.dynamicQuery(dynamicQuery);
    }

    private Serializable _fetchLatestStructureVersionId(DDMStructure ddmStructure) {
        try {
            DDMStructureVersion ddmStructureVersion = ddmStructure.getStructureVersion();
            return Long.valueOf(ddmStructureVersion.getStructureVersionId());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"An error occured when getting structure version ID", (Throwable)pe);
            }
            return Integer.valueOf(0);
        }
    }
}

