/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator;

import com.liferay.dynamic.data.mapping.exception.StorageException;

public class DDMFormValuesValidationException
extends StorageException {
    public DDMFormValuesValidationException() {
    }

    public DDMFormValuesValidationException(String msg) {
        super(msg);
    }

    public DDMFormValuesValidationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public DDMFormValuesValidationException(Throwable throwable) {
        super(throwable);
    }

    public static class RequiredValue
    extends DDMFormValuesValidationException {
        private final String _fieldName;

        public RequiredValue(String fieldName) {
            super(String.format("No value defined for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidValuesSize
    extends DDMFormValuesValidationException {
        private String _fieldName;

        public MustSetValidValuesSize(String fieldName) {
            super(String.format("Incorrect number of values set for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidValue
    extends DDMFormValuesValidationException {
        private String _fieldName;

        public MustSetValidValue(String fieldName) {
            super(String.format("Invalid value set for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public MustSetValidValue(String fieldName, Throwable throwable) {
            super(String.format("Invalid value set for field name %s", fieldName), throwable);
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidField
    extends DDMFormValuesValidationException {
        private String _fieldName;

        public MustSetValidField(String fieldName) {
            super(String.format("There is no field name %s defined on form", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidDefaultLocale
    extends DDMFormValuesValidationException {
        private String _fieldName;

        public MustSetValidDefaultLocale(String fieldName) {
            super(String.format("Invalid default locale set for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidAvailableLocales
    extends DDMFormValuesValidationException {
        private String _fieldName;

        public MustSetValidAvailableLocales(String fieldName) {
            super(String.format("Invalid available locales set for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustNotSetValue
    extends DDMFormValuesValidationException {
        private String _fieldName;

        public MustNotSetValue(String fieldName) {
            super(String.format("Value should not be set for transient field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }
}

