/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.FieldRenderer;
import com.liferay.dynamic.data.mapping.storage.FieldRendererFactory;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Field
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(Field.class);
    private long _ddmStructureId;
    private Locale _defaultLocale;
    private String _name;
    private Map<Locale, List<Serializable>> _valuesMap = new HashMap<Locale, List<Serializable>>();

    public Field() {
    }

    public Field(long ddmStructureId, String name, List<Serializable> values, Locale locale) {
        this._ddmStructureId = ddmStructureId;
        this._name = name;
        this._valuesMap.put(locale, values);
    }

    public Field(long ddmStructureId, String name, Map<Locale, List<Serializable>> valuesMap, Locale defaultLocale) {
        this._ddmStructureId = ddmStructureId;
        this._name = name;
        this._valuesMap = valuesMap;
        this._defaultLocale = defaultLocale;
    }

    public Field(long ddmStructureId, String name, Serializable value) {
        this._ddmStructureId = ddmStructureId;
        this._name = name;
        this.setValue(value);
    }

    public Field(String name, Serializable value) {
        this(0L, name, value);
    }

    public void addValue(Locale locale, Serializable value) {
        List<Serializable> values = this._valuesMap.get(locale);
        if (values == null) {
            values = new ArrayList<Serializable>();
            this._valuesMap.put(locale, values);
        }
        values.add(value);
    }

    public void addValues(Locale locale, List<Serializable> values) {
        for (Serializable value : values) {
            this.addValue(locale, value);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return this._ddmStructureId == field._ddmStructureId && Objects.equals(this._name, field._name) && Objects.equals(this._valuesMap, field._valuesMap);
    }

    public Set<Locale> getAvailableLocales() {
        return this._valuesMap.keySet();
    }

    public String getDataType() throws PortalException {
        DDMStructure ddmStructure = this.getDDMStructure();
        return ddmStructure.getFieldDataType(this._name);
    }

    public DDMStructure getDDMStructure() {
        return DDMStructureLocalServiceUtil.fetchStructure(this._ddmStructureId);
    }

    public long getDDMStructureId() {
        return this._ddmStructureId;
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public String getName() {
        return this._name;
    }

    public String getRenderedValue(Locale locale) throws PortalException {
        FieldRenderer fieldRenderer = this.getFieldRenderer();
        return fieldRenderer.render(this, locale);
    }

    public String getRenderedValue(Locale locale, int valueIndex) throws PortalException {
        FieldRenderer fieldRenderer = this.getFieldRenderer();
        return fieldRenderer.render(this, locale, valueIndex);
    }

    public String getType() throws PortalException {
        DDMStructure ddmStructure = this.getDDMStructure();
        return ddmStructure.getFieldType(this._name);
    }

    public Serializable getValue() {
        return this.getValue(this.getDefaultLocale());
    }

    public Serializable getValue(Locale locale) {
        List<Serializable> values = this._getValues(locale);
        if (values.isEmpty()) {
            return null;
        }
        try {
            DDMStructure ddmStructure = this.getDDMStructure();
            if (ddmStructure == null) {
                return values.get(0);
            }
            if (this.isRepeatable() || values.size() > 1) {
                return FieldConstants.getSerializable(this.getDataType(), values);
            }
            return values.get(0);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to extract field value", (Throwable)exception);
            return null;
        }
    }

    public Serializable getValue(Locale locale, int index) {
        List<Serializable> values = this._getValues(locale);
        if (index >= values.size()) {
            return null;
        }
        return values.get(index);
    }

    public List<Serializable> getValues(Locale locale) {
        return this._getValues(locale);
    }

    public Map<Locale, List<Serializable>> getValuesMap() {
        return this._valuesMap;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (long)this._ddmStructureId);
        hash = HashUtil.hash((int)hash, (Object)this._name);
        return HashUtil.hash((int)hash, this._valuesMap);
    }

    public boolean isPrivate() {
        try {
            return this._name.startsWith("_");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isRepeatable() throws PortalException {
        if (this.isPrivate()) {
            return false;
        }
        DDMStructure ddmStructure = this.getDDMStructure();
        return ddmStructure.isFieldRepeatable(this._name);
    }

    public void setDDMStructureId(long ddmStructureId) {
        this._ddmStructureId = ddmStructureId;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(Locale locale, Serializable value) {
        Class<?> clazz;
        List<Serializable> values = null;
        if (value != null && (clazz = value.getClass()).isArray()) {
            values = ListUtil.fromArray((Object[])((Serializable[])value));
        }
        if (values == null) {
            values = new ArrayList<Serializable>();
            values.add(value);
        }
        this._valuesMap.put(locale, values);
    }

    public void setValue(Serializable value) {
        this.setValue(LocaleUtil.getSiteDefault(), value);
    }

    public void setValues(Locale locale, List<Serializable> values) {
        this._valuesMap.put(locale, values);
    }

    public void setValuesMap(Map<Locale, List<Serializable>> valuesMap) {
        this._valuesMap = valuesMap;
    }

    protected FieldRenderer getFieldRenderer() throws PortalException {
        DDMStructure ddmStructure = this.getDDMStructure();
        String dataType = null;
        if (ddmStructure != null) {
            dataType = this.getDataType();
        }
        return FieldRendererFactory.getFieldRenderer(dataType);
    }

    private List<Serializable> _getValues(Locale locale) {
        List<Serializable> values;
        Set<Locale> availableLocales = this.getAvailableLocales();
        if (!availableLocales.contains(locale)) {
            locale = this.getDefaultLocale();
        }
        if (locale == null) {
            locale = LocaleUtil.getSiteDefault();
        }
        if ((values = this._valuesMap.get(locale)) == null) {
            return Collections.emptyList();
        }
        return values;
    }
}

