/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplayTabItem;
import com.liferay.dynamic.data.mapping.util.DDMNavigationHelper;
import com.liferay.dynamic.data.mapping.util.DDMNavigationHelperImpl;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@ProviderType
public abstract class BaseDDMDisplay
implements DDMDisplay {
    private static final Set<String> _templateLanguageTypes = SetUtil.fromArray((Object[])new String[]{"ftl", "vm"});
    private static final Set<String> _viewTemplateExcludedColumnNames = SetUtil.fromArray((Object[])new String[]{"structure"});

    @Override
    public String getAvailableFields() {
        return "Liferay.FormBuilder.AVAILABLE_FIELDS.DDM_STRUCTURE";
    }

    @Override
    public String getConfirmSelectStructureMessage(Locale locale) {
        return "";
    }

    @Override
    public String getConfirmSelectTemplateMessage(Locale locale) {
        return "";
    }

    @Override
    public DDMNavigationHelper getDDMNavigationHelper() {
        return new DDMNavigationHelperImpl();
    }

    @Override
    public DDMDisplayTabItem getDefaultTabItem() {
        return new DDMDisplayTabItem(){

            @Override
            public String getTitle(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
                String scopeTitle = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"scopeTitle");
                if (Validator.isNull((String)scopeTitle)) {
                    return BaseDDMDisplay.this.getTitle(liferayPortletRequest.getLocale());
                }
                return scopeTitle;
            }
        };
    }

    @Override
    public String getDefaultTemplateLanguage() {
        return "ftl";
    }

    @Override
    public String getDescription(Locale locale) {
        return null;
    }

    @Override
    public String getEditStructureDefaultValuesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, DDMStructure structure, String redirectURL) throws Exception {
        return null;
    }

    @Override
    public String getEditTemplateBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classNameId, long classPK, long resourceClassNameId, String portletResource) throws Exception {
        return this.getViewTemplatesURL(liferayPortletRequest, liferayPortletResponse, classNameId, classPK, resourceClassNameId);
    }

    @Override
    public String getEditTemplateTitle(DDMStructure structure, DDMTemplate template, Locale locale) {
        if (structure != null && template != null) {
            return StringUtil.appendParentheticalSuffix((String)template.getName(locale), (String)structure.getName(locale));
        }
        if (structure != null) {
            return LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"new-template-for-structure-x", (Object)structure.getName(locale), (boolean)false);
        }
        if (template != null) {
            return template.getName(locale);
        }
        return this.getDefaultEditTemplateTitle(locale);
    }

    @Override
    public String getEditTemplateTitle(long classNameId, Locale locale) {
        TemplateHandler templateHandler;
        if (classNameId > 0L && (templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)classNameId)) != null) {
            return LanguageUtil.format((Locale)locale, (String)"new-x", (Object)templateHandler.getName(locale), (boolean)false);
        }
        return this.getDefaultEditTemplateTitle(locale);
    }

    @Override
    public String getStorageType() {
        return "";
    }

    @Override
    public String getStructureName(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)"structure");
    }

    @Override
    public String getStructureType() {
        return "";
    }

    @Override
    public List<DDMDisplayTabItem> getTabItems() {
        return Arrays.asList(this.getDefaultTabItem());
    }

    @Override
    public long[] getTemplateClassNameIds(long classNameId) {
        if (classNameId > 0L) {
            return new long[]{classNameId};
        }
        return TemplateHandlerRegistryUtil.getClassNameIds();
    }

    @Override
    public long[] getTemplateClassPKs(long companyId, long classNameId, long classPK) throws Exception {
        if (classPK > 0L) {
            return new long[]{classPK};
        }
        ArrayList<Long> classPKs = new ArrayList<Long>();
        classPKs.add(0L);
        List<DDMStructure> structures = DDMStructureLocalServiceUtil.getClassStructures(companyId, PortalUtil.getClassNameId((String)this.getStructureType()));
        for (DDMStructure structure : structures) {
            classPKs.add(structure.getPrimaryKey());
        }
        return ArrayUtil.toLongArray(classPKs);
    }

    @Override
    public long[] getTemplateGroupIds(ThemeDisplay themeDisplay, boolean includeAncestorTemplates) throws Exception {
        HttpServletRequest httpServletRequest = themeDisplay.getRequest();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        long groupId = themeDisplay.getScopeGroupId();
        String refererPortletName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)(portletDisplay.getNamespace() + "refererPortletName"));
        if (Validator.isNotNull((String)refererPortletName)) {
            groupId = PortalUtil.getScopeGroupId((HttpServletRequest)httpServletRequest, (String)refererPortletName, (boolean)true);
        }
        if (includeAncestorTemplates) {
            return PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId);
        }
        return new long[]{groupId};
    }

    @Override
    public long getTemplateHandlerClassNameId(DDMTemplate template, long classNameId) {
        if (template != null) {
            return template.getClassNameId();
        }
        return classNameId;
    }

    @Override
    public Set<String> getTemplateLanguageTypes() {
        return _templateLanguageTypes;
    }

    @Override
    public String getTemplateMode() {
        return "";
    }

    @Override
    public String getTemplateType() {
        return "";
    }

    @Override
    public String getTemplateType(DDMTemplate template, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)template.getType());
    }

    @Override
    public String getTitle(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"structures");
    }

    @Override
    public String getViewStructuresBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        return ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"backURL");
    }

    @Override
    public String getViewTemplatesBackURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classPK) throws Exception {
        DDMNavigationHelper ddmNavigationHelper = this.getDDMNavigationHelper();
        if (ddmNavigationHelper.isNavigationStartsOnSelectStructure(liferayPortletRequest)) {
            return ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"redirect");
        }
        String portletId = PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view.jsp");
        return portletURL.toString();
    }

    @Override
    public Set<String> getViewTemplatesExcludedColumnNames() {
        return _viewTemplateExcludedColumnNames;
    }

    @Override
    public String getViewTemplatesTitle(DDMStructure structure, boolean controlPanel, boolean search, Locale locale) {
        if (structure != null) {
            return LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"templates-for-structure-x", (Object)structure.getName(locale), (boolean)false);
        }
        return this.getDefaultViewTemplateTitle(locale);
    }

    @Override
    public String getViewTemplatesTitle(DDMStructure structure, Locale locale) {
        return this.getViewTemplatesTitle(structure, false, false, locale);
    }

    @Override
    public boolean isEnableSelectStructureLink(DDMStructure structure, long classPK) {
        if (structure.getStructureId() == classPK) {
            return false;
        }
        if (classPK == 0L) {
            return true;
        }
        if (structure.getParentStructureId() == 0L) {
            return true;
        }
        DDMStructure parentStructure = DDMStructureLocalServiceUtil.fetchStructure(structure.getParentStructureId());
        while (parentStructure != null) {
            if (parentStructure.getStructureId() == classPK) {
                return false;
            }
            parentStructure = DDMStructureLocalServiceUtil.fetchStructure(parentStructure.getParentStructureId());
        }
        return true;
    }

    @Override
    public boolean isShowAddButton(Group scopeGroup) {
        String ddmStructurePortletId;
        String portletId = this.getPortletId();
        if (portletId.equals(ddmStructurePortletId = PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW))) {
            return false;
        }
        return !scopeGroup.hasLocalOrRemoteStagingGroup() || !scopeGroup.isStagedPortlet(portletId);
    }

    @Override
    public boolean isShowBackURLInTitleBar() {
        return false;
    }

    @Override
    public boolean isShowConfirmSelectStructure() {
        return false;
    }

    @Override
    public boolean isShowConfirmSelectTemplate() {
        return false;
    }

    @Override
    public boolean isShowStructureSelector() {
        return false;
    }

    @Override
    public boolean isVersioningEnabled() {
        return false;
    }

    protected String getDefaultEditTemplateTitle(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)"new-template");
    }

    protected String getDefaultViewTemplateTitle(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"templates");
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
        ResourceBundle ddmDisplayResourceBundle = null;
        if (resourceBundleLoader != null) {
            ddmDisplayResourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        }
        ResourceBundle baseDDMDisplayResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, (ClassLoader)BaseDDMDisplay.class.getClassLoader());
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        if (ddmDisplayResourceBundle == null) {
            return new AggregateResourceBundle(new ResourceBundle[]{baseDDMDisplayResourceBundle, portalResourceBundleLoader.loadResourceBundle(locale)});
        }
        return new AggregateResourceBundle(new ResourceBundle[]{ddmDisplayResourceBundle, baseDDMDisplayResourceBundle, portalResourceBundleLoader.loadResourceBundle(locale)});
    }

    protected String getViewTemplatesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classNameId, long classPK, long resourceClassNameId) throws Exception {
        String portletId = PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)portletId, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view_template.jsp");
        portletURL.setParameter("classNameId", String.valueOf(classNameId));
        portletURL.setParameter("classPK", String.valueOf(classPK));
        portletURL.setParameter("resourceClassNameId", String.valueOf(resourceClassNameId));
        return portletURL.toString();
    }
}

