/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Iterator;
import java.util.Locale;

public class LocalizedValueUtil {
    public static JSONObject toJSONObject(LocalizedValue localizedValue) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (localizedValue == null) {
            return jsonObject;
        }
        for (Locale availableLocale : localizedValue.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localizedValue.getString(availableLocale));
        }
        return jsonObject;
    }

    public static LocalizedValue toLocalizedValue(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        LocalizedValue localizedValue = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }
}

