/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Set;

public class DDMExpressionException
extends PortalException {
    public DDMExpressionException() {
    }

    public DDMExpressionException(String msg) {
        super(msg);
    }

    public DDMExpressionException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public DDMExpressionException(Throwable cause) {
        super(cause);
    }

    public static class NumberExceedsSupportedRange
    extends DDMExpressionException {
        public NumberExceedsSupportedRange() {
            super("The number entered exceeds the supported range");
        }
    }

    public static class InvalidSyntax
    extends DDMExpressionException {
        public InvalidSyntax(Throwable cause) {
            super("The expression syntax is invalid", cause);
        }
    }

    public static class IncompatipleReturnType
    extends DDMExpressionException {
        public IncompatipleReturnType() {
            super("The evaluation return type differs from DDM Expression type");
        }
    }

    public static class FunctionNotDefined
    extends DDMExpressionException {
        private final Set<String> _undefinedFunctionNames;

        public FunctionNotDefined(Set<String> undefinedFunctionNames) {
            super(String.format("The functions \"%s\" were not defined", StringUtil.merge(undefinedFunctionNames)));
            this._undefinedFunctionNames = undefinedFunctionNames;
        }

        public Set<String> getUndefinedFunctionNames() {
            return this._undefinedFunctionNames;
        }
    }
}

