/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.context;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.function.Consumer;

public class DDMFormContextVisitor {
    private Consumer<JSONObject> _columnConsumer = new NOPJSONObjectConsumer();
    private Consumer<JSONObject> _fieldConsumer = new NOPJSONObjectConsumer();
    private Consumer<JSONObject> _pageConsumer = new NOPJSONObjectConsumer();
    private final JSONArray _pagesJSONArray;
    private Consumer<JSONObject> _rowConsumer = new NOPJSONObjectConsumer();

    public DDMFormContextVisitor(JSONArray pagesJSONArray) {
        this._pagesJSONArray = pagesJSONArray;
    }

    public void onVisitColumn(Consumer<JSONObject> columnConsumer) {
        this._columnConsumer = columnConsumer;
    }

    public void onVisitField(Consumer<JSONObject> fieldConsumer) {
        this._fieldConsumer = fieldConsumer;
    }

    public void onVisitPage(Consumer<JSONObject> pageConsumer) {
        this._pageConsumer = pageConsumer;
    }

    public void onVisitRow(Consumer<JSONObject> rowConsumer) {
        this._rowConsumer = rowConsumer;
    }

    public void visit() {
        this.traversePages(this._pagesJSONArray);
    }

    protected void traverseColumns(JSONArray columnnsJSONArray) {
        for (int i = 0; i < columnnsJSONArray.length(); ++i) {
            JSONObject columnJSONObject = columnnsJSONArray.getJSONObject(i);
            this.traverseFields(columnJSONObject.getJSONArray("fields"));
            this._columnConsumer.accept(columnJSONObject);
        }
    }

    protected void traverseFields(JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            this._fieldConsumer.accept(fieldJSONObject);
        }
    }

    protected void traversePages(JSONArray pagesJSONArray) {
        for (int i = 0; i < pagesJSONArray.length(); ++i) {
            JSONObject pageJSONObject = pagesJSONArray.getJSONObject(i);
            this.traverseRows(pageJSONObject.getJSONArray("rows"));
            this._pageConsumer.accept(pageJSONObject);
        }
    }

    protected void traverseRows(JSONArray rowsJSONArray) {
        for (int i = 0; i < rowsJSONArray.length(); ++i) {
            JSONObject rowJSONObject = rowsJSONArray.getJSONObject(i);
            this.traverseColumns(rowJSONObject.getJSONArray("columns"));
            this._rowConsumer.accept(rowJSONObject);
        }
    }

    private static class NOPJSONObjectConsumer
    implements Consumer<JSONObject> {
        private NOPJSONObjectConsumer() {
        }

        @Override
        public void accept(JSONObject jsonObject) {
        }
    }
}

