/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.template;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.template.TemplateVariableCodeHandler;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Writer;
import java.util.Set;

public class DDMTemplateVariableCodeHandler
implements TemplateVariableCodeHandler {
    private final ClassLoader _classLoader;
    private final Set<String> _templateNames;
    private final String _templatePath;

    public DDMTemplateVariableCodeHandler(ClassLoader classLoader, String templatePath, Set<String> templateNames) {
        this._classLoader = classLoader;
        this._templatePath = templatePath;
        this._templateNames = templateNames;
    }

    public String[] generate(TemplateVariableDefinition templateVariableDefinition, String language) throws Exception {
        String templateId = this.getTemplateId(templateVariableDefinition.getDataType());
        String content = this.getTemplateContent(this.getTemplate(templateId), templateVariableDefinition, language);
        if (templateVariableDefinition.isRepeatable()) {
            content = this.handleRepeatableField(templateVariableDefinition, language, content);
        }
        return new String[]{content};
    }

    protected Template getTemplate(String templateId) throws Exception {
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"ftl", (String)StringBundler.concat((String[])new String[]{ClassLoaderPool.getContextName((ClassLoader)this._classLoader), "_CLASS_LOADER_CONTEXT_", templateId}));
        return TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
    }

    protected String getTemplateContent(Template template, TemplateVariableDefinition templateVariableDefinition, String language) throws Exception {
        this.prepareTemplate(template, templateVariableDefinition, language);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate((Writer)writer);
        return StringUtil.trim((String)writer.toString());
    }

    protected String getTemplateId(String dataType) {
        if (!this._templateNames.contains(dataType)) {
            dataType = "common";
        }
        return this.getTemplatePath() + dataType + ".ftl";
    }

    protected String getTemplatePath() {
        return this._templatePath;
    }

    protected String handleRepeatableField(TemplateVariableDefinition templateVariableDefinition, String language, String templateContent) throws Exception {
        Template template = this.getTemplate(this.getTemplatePath() + "repeatable.ftl");
        templateContent = StringUtil.replace((String)templateContent, (char)'\n', (String)"\n\t\t");
        template.put((Object)"templateContent", (Object)templateContent);
        return this.getTemplateContent(template, templateVariableDefinition, language);
    }

    protected void prepareTemplate(Template template, TemplateVariableDefinition templateVariableDefinition, String language) {
        template.put((Object)"dataType", (Object)templateVariableDefinition.getDataType());
        template.put((Object)"help", (Object)templateVariableDefinition.getHelp());
        template.put((Object)"label", (Object)templateVariableDefinition.getLabel());
        template.put((Object)"language", (Object)language);
        template.put((Object)"name", (Object)templateVariableDefinition.getName());
        template.put((Object)"repeatable", (Object)templateVariableDefinition.isRepeatable());
    }
}

