/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.portal.kernel.util.HashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMForm
implements Serializable {
    private Set<Locale> _availableLocales = new LinkedHashSet<Locale>();
    private List<DDMFormField> _ddmFormFields = new ArrayList<DDMFormField>();
    private List<DDMFormRule> _ddmFormRules = new ArrayList<DDMFormRule>();
    private DDMFormSuccessPageSettings _ddmFormSuccessPageSettings = new DDMFormSuccessPageSettings();
    private Locale _defaultLocale;

    public DDMForm() {
    }

    public DDMForm(DDMForm ddmForm) {
        this._availableLocales = new LinkedHashSet<Locale>(ddmForm._availableLocales);
        this._defaultLocale = ddmForm._defaultLocale;
        for (DDMFormField ddmFormField : ddmForm._ddmFormFields) {
            this.addDDMFormField(new DDMFormField(ddmFormField));
        }
        for (DDMFormRule ddmFormRule : ddmForm._ddmFormRules) {
            this.addDDMFormRule(new DDMFormRule(ddmFormRule));
        }
        this._ddmFormSuccessPageSettings = new DDMFormSuccessPageSettings(ddmForm.getDDMFormSuccessPageSettings());
    }

    public void addAvailableLocale(Locale locale) {
        this._availableLocales.add(locale);
    }

    public void addDDMFormField(DDMFormField ddmFormField) {
        ddmFormField.setDDMForm(this);
        this._ddmFormFields.add(ddmFormField);
    }

    public void addDDMFormRule(DDMFormRule ddmFormRule) {
        this._ddmFormRules.add(ddmFormRule);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DDMForm)) {
            return false;
        }
        DDMForm ddmForm = (DDMForm)obj;
        return Objects.equals(this._availableLocales, ddmForm._availableLocales) && Objects.equals(this._defaultLocale, ddmForm._defaultLocale) && Objects.equals(this._ddmFormFields, ddmForm._ddmFormFields) && Objects.equals(this._ddmFormRules, ddmForm._ddmFormRules) && Objects.equals(this._ddmFormSuccessPageSettings, ddmForm._ddmFormSuccessPageSettings);
    }

    public Set<Locale> getAvailableLocales() {
        return this._availableLocales;
    }

    public List<DDMFormField> getDDMFormFields() {
        return this._ddmFormFields;
    }

    public Map<String, DDMFormField> getDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        LinkedHashMap<String, DDMFormField> ddmFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField ddmFormField : this._ddmFormFields) {
            ddmFormFieldsMap.put(ddmFormField.getName(), ddmFormField);
            if (!includeNestedDDMFormFields) continue;
            ddmFormFieldsMap.putAll(ddmFormField.getNestedDDMFormFieldsMap());
        }
        return ddmFormFieldsMap;
    }

    public List<DDMFormRule> getDDMFormRules() {
        return this._ddmFormRules;
    }

    public DDMFormSuccessPageSettings getDDMFormSuccessPageSettings() {
        return this._ddmFormSuccessPageSettings;
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public Map<String, DDMFormField> getNontransientDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        LinkedHashMap<String, DDMFormField> ddmFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField ddmFormField : this._ddmFormFields) {
            if (!ddmFormField.isTransient()) {
                ddmFormFieldsMap.put(ddmFormField.getName(), ddmFormField);
            }
            if (!includeNestedDDMFormFields) continue;
            ddmFormFieldsMap.putAll(ddmFormField.getNontransientNestedDDMFormFieldsMap());
        }
        return ddmFormFieldsMap;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._availableLocales);
        hash = HashUtil.hash((int)hash, (Object)this._defaultLocale);
        hash = HashUtil.hash((int)hash, this._ddmFormFields);
        hash = HashUtil.hash((int)hash, this._ddmFormRules);
        return HashUtil.hash((int)hash, (Object)this._ddmFormSuccessPageSettings);
    }

    public void setAvailableLocales(Set<Locale> availableLocales) {
        this._availableLocales = availableLocales;
    }

    public void setDDMFormFields(List<DDMFormField> ddmFormFields) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            ddmFormField.setDDMForm(this);
        }
        this._ddmFormFields = ddmFormFields;
    }

    public void setDDMFormRules(List<DDMFormRule> ddmFormRules) {
        this._ddmFormRules = ddmFormRules;
    }

    public void setDDMFormSuccessPageSettings(DDMFormSuccessPageSettings ddmFormSuccessPageSettings) {
        this._ddmFormSuccessPageSettings = new DDMFormSuccessPageSettings(ddmFormSuccessPageSettings);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }
}

