/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class FieldConstants {
    public static final String BOOLEAN = "boolean";
    public static final String DATA_TYPE = "dataType";
    public static final String DATE = "date";
    public static final String DOCUMENT_LIBRARY = "document-library";
    public static final String DOUBLE = "double";
    public static final String EDITABLE = "editable";
    public static final String FLOAT = "float";
    public static final String HTML = "html";
    public static final String IMAGE = "image";
    public static final String INTEGER = "integer";
    public static final String LABEL = "label";
    public static final String LONG = "long";
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String PREDEFINED_VALUE = "predefinedValue";
    public static final String PRIVATE = "private";
    public static final String REQUIRED = "required";
    public static final String SHORT = "short";
    public static final String SHOW = "showLabel";
    public static final String SORTABLE = "sortable";
    public static final String STRING = "string";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    private static final Log _log = LogFactoryUtil.getLog(FieldConstants.class);

    public static final Serializable getSerializable(String type, List<Serializable> values) {
        if (Validator.isNull((String)type)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid type " + type));
            }
            return values.toArray(new String[0]);
        }
        if (FieldConstants.isNumericType(type)) {
            values.removeAll(Collections.singleton(""));
        }
        if (type.equals(BOOLEAN)) {
            return values.toArray(new Boolean[0]);
        }
        if (type.equals(DATE)) {
            return values.toArray(new String[0]);
        }
        if (type.equals(DOUBLE)) {
            return values.toArray(new Double[0]);
        }
        if (type.equals(FLOAT)) {
            return values.toArray(new Float[0]);
        }
        if (type.equals(INTEGER)) {
            return values.toArray(new Integer[0]);
        }
        if (type.equals(LONG)) {
            return values.toArray(new Long[0]);
        }
        if (type.equals(NUMBER)) {
            return values.toArray(new Number[0]);
        }
        if (type.equals(SHORT)) {
            return values.toArray(new Short[0]);
        }
        return values.toArray(new String[0]);
    }

    public static final Serializable getSerializable(String type, String value) {
        if (Validator.isNull((String)type)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid type " + type));
            }
            return value;
        }
        if (FieldConstants.isNumericType(type) && Validator.isNull((String)value)) {
            return "";
        }
        if (type.equals(BOOLEAN)) {
            return Boolean.valueOf(GetterUtil.getBoolean((String)value));
        }
        if (type.equals(DATE) && Validator.isNotNull((String)value)) {
            return value;
        }
        if (type.equals(DOUBLE)) {
            return Double.valueOf(GetterUtil.getDouble((String)value));
        }
        if (type.equals(FLOAT)) {
            return Float.valueOf(GetterUtil.getFloat((String)value));
        }
        if (type.equals(INTEGER)) {
            return Integer.valueOf(GetterUtil.getInteger((String)value));
        }
        if (type.equals(LONG)) {
            return Long.valueOf(GetterUtil.getLong((String)value));
        }
        if (type.equals(NUMBER)) {
            return GetterUtil.getNumber((String)value);
        }
        if (type.equals(SHORT)) {
            return Short.valueOf(GetterUtil.getShort((String)value));
        }
        return value;
    }

    public static final boolean isNumericType(String type) {
        return type.equals(DOUBLE) || type.equals(FLOAT) || type.equals(INTEGER) || type.equals(LONG) || type.equals(NUMBER) || type.equals(SHORT);
    }
}

