/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class DDMDataProviderRequest {
    private DDMDataProviderContext _ddmDataProviderContext;
    private final String _ddmDataProviderInstanceId;
    private final HttpServletRequest _httpServletRequest;
    private final Map<String, String> _parameters = new HashMap<String, String>();

    public DDMDataProviderRequest(String ddmDataProviderInstanceId, HttpServletRequest httpServletRequest) {
        this._ddmDataProviderInstanceId = ddmDataProviderInstanceId;
        this._httpServletRequest = httpServletRequest;
    }

    public DDMDataProviderContext getDDMDataProviderContext() {
        return this._ddmDataProviderContext;
    }

    public String getDDMDataProviderInstanceId() {
        return this._ddmDataProviderInstanceId;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    public Locale getLocale() {
        return this._httpServletRequest.getLocale();
    }

    public String getParameter(String name) {
        return this._parameters.get(name);
    }

    public <T> Optional<T> getParameterOptional(String name, Class<?> clazz) {
        String value = this._parameters.get(name);
        if (value == null) {
            return Optional.empty();
        }
        Class<?> valueClass = value.getClass();
        if (clazz.isAssignableFrom(valueClass)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public Map<String, String> getParameters() {
        return this._parameters;
    }

    public void queryString(Map<String, String> parameters) {
        this._parameters.putAll(parameters);
    }

    public void queryString(String name, String value) {
        this._parameters.put(name, value);
    }

    public void setDDMDataProviderContext(DDMDataProviderContext ddmDataProviderContext) {
        this._ddmDataProviderContext = ddmDataProviderContext;
    }
}

