/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.data.provider;

import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormInstanceFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Marcellus Tavares
 */
public class DDMDataProviderContext {

	public DDMDataProviderContext(DDMFormValues ddmFormValues) {
		_ddmFormValues = ddmFormValues;
	}

	/**
	 * @deprecated As of Judson (7.1.x), replaced by {@link
	 *             DDMDataProviderRequest#queryString(Map)}
	 */
	@Deprecated
	public void addParameters(Map<String, String> parameters) {
		_parameters.putAll(parameters);
	}

	/**
	 * @deprecated As of Judson (7.1.x), replaced by {@link
	 *             DDMDataProviderRequest#getParameters()}
	 */
	@Deprecated
	public Map<String, String> getParameters() {
		return _parameters;
	}

	public <T> T getSettingsInstance(Class<T> clazz) {
		return DDMFormInstanceFactory.create(clazz, _ddmFormValues);
	}

	private final DDMFormValues _ddmFormValues;
	private final Map<String, String> _parameters = new HashMap<>();

}