/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMForm
implements Serializable {
    private Set<Locale> _availableLocales = new LinkedHashSet<Locale>();
    private List<DDMFormField> _ddmFormFields = new ArrayList<DDMFormField>();
    private Locale _defaultLocale;

    public DDMForm() {
    }

    public DDMForm(DDMForm ddmForm) {
        this._availableLocales = new LinkedHashSet<Locale>(ddmForm._availableLocales);
        this._defaultLocale = ddmForm._defaultLocale;
        for (DDMFormField ddmFormField : ddmForm._ddmFormFields) {
            this.addDDMFormField(new DDMFormField(ddmFormField));
        }
    }

    public void addAvailableLocale(Locale locale) {
        this._availableLocales.add(locale);
    }

    public void addDDMFormField(DDMFormField ddmFormField) {
        ddmFormField.setDDMForm(this);
        this._ddmFormFields.add(ddmFormField);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DDMForm)) {
            return false;
        }
        DDMForm ddmForm = (DDMForm)obj;
        return Validator.equals(this._availableLocales, ddmForm._availableLocales) && Validator.equals((Object)this._defaultLocale, (Object)ddmForm._defaultLocale) && Validator.equals(this._ddmFormFields, ddmForm._ddmFormFields);
    }

    public Set<Locale> getAvailableLocales() {
        return this._availableLocales;
    }

    public List<DDMFormField> getDDMFormFields() {
        return this._ddmFormFields;
    }

    public Map<String, DDMFormField> getDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        LinkedHashMap<String, DDMFormField> ddmFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField ddmFormField : this._ddmFormFields) {
            ddmFormFieldsMap.put(ddmFormField.getName(), ddmFormField);
            if (!includeNestedDDMFormFields) continue;
            ddmFormFieldsMap.putAll(ddmFormField.getNestedDDMFormFieldsMap());
        }
        return ddmFormFieldsMap;
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._availableLocales);
        hash = HashUtil.hash((int)hash, (Object)this._defaultLocale);
        return HashUtil.hash((int)hash, this._ddmFormFields);
    }

    public void setAvailableLocales(Set<Locale> availableLocales) {
        this._availableLocales = availableLocales;
    }

    public void setDDMFormFields(List<DDMFormField> ddmFormFields) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            ddmFormField.setDDMForm(this);
        }
        this._ddmFormFields = ddmFormFields;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }
}

