/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.form.field.type;

import com.liferay.dynamic.data.mapping.annotations.DDMForm;
import com.liferay.dynamic.data.mapping.annotations.DDMFormField;
import com.liferay.dynamic.data.mapping.annotations.DDMFormLayout;
import com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.annotations.DDMFormLayoutRow;
import com.liferay.petra.string.StringPool;

/**
 * @author Marcellus Tavares
 */
@DDMForm
@DDMFormLayout(
	{
		@DDMFormLayoutPage(
			title = "properties",
			value = {
				@DDMFormLayoutRow(
					{
						@DDMFormLayoutColumn(
							size = 12,
							value = {
								"dataType", "name", "fieldReference", "type"
							}
						)
					}
				)
			}
		)
	}
)
public interface DDMFormFieldTypeSettings {

	@DDMFormField(
		predefinedValue = "string", required = true,
		visibilityExpression = "FALSE"
	)
	public String dataType();

	@DDMFormField(
		label = "%field-reference",
		properties = {
			"normalizeField=true",
			"tooltip=%field-reference-serves-as-a-frienldy-identifier"
		}
	)
	public default String fieldReference() {
		return StringPool.BLANK;
	}

	@DDMFormField(
		label = "%field-name", properties = "normalizeField=true",
		required = true, visibilityExpression = "FALSE"
	)
	public String name();

	@DDMFormField(required = true, visibilityExpression = "FALSE")
	public String type();

}