/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator;

import com.liferay.portal.kernel.exception.PortalException;
import java.util.Set;

public class DDMFormLayoutValidationException
extends PortalException {
    public DDMFormLayoutValidationException() {
    }

    public DDMFormLayoutValidationException(String msg) {
        super(msg);
    }

    public DDMFormLayoutValidationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public DDMFormLayoutValidationException(Throwable throwable) {
        super(throwable);
    }

    public static class MustSetEqualLocaleForLayoutAndTitle
    extends DDMFormLayoutValidationException {
        public MustSetEqualLocaleForLayoutAndTitle() {
            super("The default locale for the DDM form layout's page title is not the same as the DDM form layout's default locale");
        }
    }

    public static class MustSetDefaultLocale
    extends DDMFormLayoutValidationException {
        public MustSetDefaultLocale() {
            super("DDM form layout does not have a default locale");
        }
    }

    public static class MustNotDuplicateFieldName
    extends DDMFormLayoutValidationException {
        private final Set<String> _duplicatedFieldNames;

        public MustNotDuplicateFieldName(Set<String> duplicatedFieldNames) {
            super(String.format("Field names %s were defined more than once", duplicatedFieldNames));
            this._duplicatedFieldNames = duplicatedFieldNames;
        }

        public Set<String> getDuplicatedFieldNames() {
            return this._duplicatedFieldNames;
        }
    }

    public static class InvalidRowSize
    extends DDMFormLayoutValidationException {
        public InvalidRowSize() {
            super("The sum of all column sizes of a row must be less than the maximum row size of 12");
        }
    }

    public static class InvalidColumnSize
    extends DDMFormLayoutValidationException {
        public InvalidColumnSize() {
            super("Column size must be positive and less than maximum row size of 12");
        }
    }
}

