/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.model;

import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.petra.string.StringUtil;
import java.util.List;

public class FunctionCallExpression
extends Expression {
    private final String _functionName;
    private final List<Expression> _parameterExpressions;

    public FunctionCallExpression(String functionName, List<Expression> parameterExpressions) {
        this._functionName = functionName;
        this._parameterExpressions = parameterExpressions;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> expressionVisitor) {
        return expressionVisitor.visit(this);
    }

    public int getArity() {
        return this._parameterExpressions.size();
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public List<Expression> getParameterExpressions() {
        return this._parameterExpressions;
    }

    public boolean hasNestedFunctions() {
        for (Expression parameterExpression : this._parameterExpressions) {
            String parameterExpressionString = parameterExpression.toString();
            if (!parameterExpressionString.matches("[aA-zZ0-9]+[(].*[aA-zZ0-9]+[(].*[)].*[)]")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._functionName);
        sb.append("(");
        sb.append(StringUtil.merge(this._parameterExpressions, (String)", "));
        sb.append(")");
        return sb.toString();
    }
}

