/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DDMFormValuesConverterUtil {
    public static List<DDMFormFieldValue> addMissingDDMFormFieldValues(Collection<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValues) {
        ArrayList<DDMFormFieldValue> newDDMFormFieldValuesList = new ArrayList<DDMFormFieldValue>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            List<DDMFormFieldValue> ddmFormFieldValuesList = ddmFormFieldValues.get(ddmFormField.getName());
            if (ddmFormFieldValuesList == null) {
                DDMFormFieldValue ddmFormFieldValue = DDMFormValuesConverterUtil._createDefaultDDMFormFieldValue(ddmFormField);
                DDMFormValuesConverterUtil._populateNestedValues(ddmFormField, ddmFormFieldValue, ddmFormFieldValues);
                newDDMFormFieldValuesList.add(ddmFormFieldValue);
                continue;
            }
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValuesList) {
                DDMFormValuesConverterUtil._populateNestedValues(ddmFormField, ddmFormFieldValue, ddmFormFieldValues);
                newDDMFormFieldValuesList.add(ddmFormFieldValue);
            }
        }
        return newDDMFormFieldValuesList;
    }

    private static DDMFormFieldValue _createDefaultDDMFormFieldValue(DDMFormField ddmFormField) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setInstanceId(StringUtil.randomString());
        ddmFormFieldValue.setName(ddmFormField.getName());
        if (ddmFormField.isLocalizable()) {
            ddmFormFieldValue.setValue(new LocalizedValue());
        } else {
            ddmFormFieldValue.setValue(new UnlocalizedValue((String)null));
        }
        return ddmFormFieldValue;
    }

    private static void _populateNestedValues(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, List<DDMFormFieldValue>> ddmFormFieldValues) {
        if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            return;
        }
        HashSet<String> currentNames = new HashSet<String>();
        for (DDMFormFieldValue dDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            currentNames.add(dDMFormFieldValue.getName());
        }
        HashSet<String> expectedNames = new HashSet<String>();
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            expectedNames.add(nestedDDMFormField.getName());
            List<DDMFormFieldValue> nestedDDMFormFieldValueList = ddmFormFieldValues.get(nestedDDMFormField.getName());
            if (nestedDDMFormFieldValueList == null) {
                ddmFormFieldValue.addNestedDDMFormFieldValue(DDMFormValuesConverterUtil._createDefaultDDMFormFieldValue(nestedDDMFormField));
                continue;
            }
            for (DDMFormFieldValue nestedDDMFormFieldValue : nestedDDMFormFieldValueList) {
                if (currentNames.contains(nestedDDMFormFieldValue.getName())) continue;
                ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
                DDMFormValuesConverterUtil._populateNestedValues(nestedDDMFormField, nestedDDMFormFieldValue, ddmFormFieldValues);
            }
        }
        List<DDMFormFieldValue> list = ddmFormFieldValue.getNestedDDMFormFieldValues();
        Iterator<DDMFormFieldValue> iterator = list.iterator();
        while (iterator.hasNext()) {
            DDMFormFieldValue currentDDMFormFieldValue = iterator.next();
            if (expectedNames.contains(currentDDMFormFieldValue.getName())) continue;
            iterator.remove();
        }
    }
}

