/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.util.NumberUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumericDDMFormFieldUtil {
    public static DecimalFormat getDecimalFormat(Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(locale);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        decimalFormat.setParseBigDecimal(true);
        return decimalFormat;
    }

    public static String getFormattedValue(Locale locale, String value) {
        if (Validator.isNull((String)value) || !NumberUtil.hasDecimalSeparator(value)) {
            return value;
        }
        DecimalFormat decimalFormat = NumericDDMFormFieldUtil.getDecimalFormat(locale);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        return StringUtil.replace((String)value, (char)value.charAt(NumberUtil.getDecimalSeparatorIndex(value)), (char)decimalFormatSymbols.getDecimalSeparator());
    }
}

