/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.exception;

import com.liferay.portal.kernel.exception.PortalException;

public class RequiredStructureException
extends PortalException {
    private RequiredStructureException(String message) {
        super(message);
    }

    public static class MustNotDeleteStructureThatHasChild
    extends RequiredStructureException {
        public long structureId;

        public MustNotDeleteStructureThatHasChild(long structureId) {
            super(String.format("Structure %s cannot be deleted because it has child structures", structureId));
            this.structureId = structureId;
        }
    }

    public static class MustNotDeleteStructureReferencedByTemplates
    extends RequiredStructureException {
        public long structureId;

        public MustNotDeleteStructureReferencedByTemplates(long structureId) {
            super(String.format("Structure %s cannot be deleted because it is referenced by one or more templates", structureId));
            this.structureId = structureId;
        }
    }

    public static class MustNotDeleteStructureReferencedByStructureLinks
    extends RequiredStructureException {
        public long structureId;

        public MustNotDeleteStructureReferencedByStructureLinks(long structureId) {
            super(String.format("Structure %s cannot be deleted because it is referenced by one or more structure links", structureId));
            this.structureId = structureId;
        }
    }
}

