/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDMFormValidationException
extends PortalException {
    public DDMFormValidationException() {
    }

    public DDMFormValidationException(String msg) {
        super(msg);
    }

    public DDMFormValidationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public DDMFormValidationException(Throwable throwable) {
        super(throwable);
    }

    private static class MustSetValidDDMFormFieldExpression
    extends DDMFormValidationException {
        protected String expression;
        protected String fieldName;

        public MustSetValidDDMFormFieldExpression(String fieldName, String expressionType, String expression) {
            super(String.format("Invalid %s expression set for field %s: %s", expressionType, fieldName, expression));
            this.fieldName = fieldName;
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public static class MustSetValidVisibilityExpression
    extends MustSetValidDDMFormFieldExpression {
        public MustSetValidVisibilityExpression(String fieldName, String expression) {
            super(fieldName, "visibility", expression);
        }

        public String getVisibilityExpression() {
            return this.expression;
        }
    }

    public static class MustSetValidValidationExpression
    extends MustSetValidDDMFormFieldExpression {
        private static final Pattern _validationExpressionPattern = Pattern.compile("(contains|match)\\((.+), \"(.+)\"\\)");

        public MustSetValidValidationExpression(String fieldName, String expression) {
            super(fieldName, "validation", expression);
        }

        public String getValidationExpression() {
            return this.expression;
        }

        public String getValidationExpressionArgument() {
            Matcher matcher = _validationExpressionPattern.matcher(this.expression);
            if (matcher.find()) {
                return matcher.group(3);
            }
            return "";
        }
    }

    public static class MustSetValidType
    extends DDMFormValidationException {
        private final String _fieldType;

        public MustSetValidType(String fieldType) {
            super(String.format("Invalid type set for field type %s", fieldType));
            this._fieldType = fieldType;
        }

        public String getFieldType() {
            return this._fieldType;
        }
    }

    public static class MustSetValidIndexType
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetValidIndexType(String fieldName) {
            super(String.format("Invalid index type set for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidFormRuleExpression
    extends DDMFormValidationException {
        private final String _expression;

        public MustSetValidFormRuleExpression(String expressionType, String expression, Throwable throwable) {
            super(String.format("Invalid form rule %s expression set: \"%s\"", expressionType, expression), throwable);
            this._expression = expression;
        }

        public String getExpression() {
            return this._expression;
        }
    }

    public static class MustSetValidDefaultLocaleForProperty
    extends DDMFormValidationException {
        private String _fieldName;
        private String _property;

        public MustSetValidDefaultLocaleForProperty(String fieldName, String property) {
            super(String.format("Invalid default locale set for the property '%s' of field name %s", property, fieldName));
            this._fieldName = fieldName;
            this._property = property;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class MustSetValidCharactersForFieldType
    extends DDMFormValidationException {
        private final String _fieldType;

        public MustSetValidCharactersForFieldType(String fieldType) {
            super(String.format("Invalid characters entered for field type %s", fieldType));
            this._fieldType = fieldType;
        }

        public String getFieldType() {
            return this._fieldType;
        }
    }

    public static class MustSetValidCharactersForFieldName
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetValidCharactersForFieldName(String fieldName) {
            super(String.format("Invalid characters entered for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidAvailableLocalesForProperty
    extends DDMFormValidationException {
        private String _fieldName;
        private String _property;

        public MustSetValidAvailableLocalesForProperty(String fieldName, String property) {
            super(String.format("Invalid available locales set for the property '%s' of field name %s", property, fieldName));
            this._fieldName = fieldName;
            this._property = property;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public String getProperty() {
            return this._property;
        }
    }

    public static class MustSetOptionsForField
    extends DDMFormValidationException {
        private String _fieldLabel;
        private String _fieldName;

        public MustSetOptionsForField(String fieldName) {
            super(String.format("At least one option must be set for field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public MustSetOptionsForField(String fieldLabel, String fieldName) {
            super(String.format("At least one option must be set for field name %s", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public String getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetFieldType
    extends DDMFormValidationException {
        private String _fieldName;

        public MustSetFieldType(String fieldName) {
            super(String.format("The field type was never set for the DDM form field with the field name %s", fieldName));
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetFieldsForForm
    extends DDMFormValidationException {
        public MustSetFieldsForForm() {
            super("At least one field must be set");
        }
    }

    public static class MustSetDefaultLocaleAsAvailableLocale
    extends DDMFormValidationException {
        private final Locale _defaultLocale;

        public MustSetDefaultLocaleAsAvailableLocale(Locale defaultLocale) {
            super(String.format("The default locale %s must be set to a valid available locale", defaultLocale));
            this._defaultLocale = defaultLocale;
        }

        public Locale getDefaultLocale() {
            return this._defaultLocale;
        }
    }

    public static class MustSetDefaultLocale
    extends DDMFormValidationException {
        public MustSetDefaultLocale() {
            super("The default locale property was not set for the DDM form");
        }
    }

    public static class MustSetAvailableLocales
    extends DDMFormValidationException {
        public MustSetAvailableLocales() {
            super("The available locales property was not set for the DDM form");
        }
    }

    public static class MustNotDuplicateFieldName
    extends DDMFormValidationException {
        private final Set<String> _duplicatedFieldNames;

        public MustNotDuplicateFieldName(Set<String> duplicatedFieldNames) {
            super(String.format("Field names %s were defined more than once", duplicatedFieldNames));
            this._duplicatedFieldNames = duplicatedFieldNames;
        }

        @Deprecated
        public MustNotDuplicateFieldName(String fieldName) {
            this(SetUtil.fromArray((Object[])new String[]{fieldName}));
        }

        public Set<String> getDuplicatedFieldNames() {
            return this._duplicatedFieldNames;
        }

        @Deprecated
        public String getFieldName() {
            String[] fieldNames = this._duplicatedFieldNames.toArray(new String[0]);
            if (fieldNames.length == 0) {
                return null;
            }
            return fieldNames[0];
        }
    }
}

