/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.display.context;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetCreateDateComparator;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetModifiedDateComparator;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetNameComparator;
import com.liferay.dynamic.data.lists.web.internal.configuration.DDLWebConfiguration;
import com.liferay.dynamic.data.lists.web.internal.display.context.util.DDLRequestHelper;
import com.liferay.dynamic.data.lists.web.internal.search.RecordSetSearch;
import com.liferay.dynamic.data.lists.web.internal.security.permission.resource.DDLPermission;
import com.liferay.dynamic.data.lists.web.internal.security.permission.resource.DDLRecordSetPermission;
import com.liferay.dynamic.data.lists.web.internal.security.permission.resource.DDMTemplatePermission;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DDLDisplayContext {
    private static final String[] _DISPLAY_VIEWS = new String[]{"descriptive", "list"};
    private final DDL _ddl;
    private String _ddlRecordDisplayStyle;
    private final DDLRecordSetLocalService _ddlRecordSetLocalService;
    private final DDLRequestHelper _ddlRequestHelper;
    private final DDLWebConfiguration _ddlWebConfiguration;
    private final DDMDisplayRegistry _ddmDisplayRegistry;
    private final DDMPermissionSupport _ddmPermissionSupport;
    private final DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMTemplate _displayDDMTemplate;
    private DDMTemplate _formDDMTemplate;
    private Boolean _hasAddDDMTemplatePermission;
    private Boolean _hasAddRecordPermission;
    private Boolean _hasAddRecordSetPermission;
    private Boolean _hasEditDisplayDDMTemplatePermission;
    private Boolean _hasEditFormDDMTemplatePermission;
    private Boolean _hasShowIconsActionPermission;
    private Boolean _hasViewPermission;
    private DDLRecordSet _recordSet;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private Boolean _showConfigurationIcon;
    private final StorageEngine _storageEngine;

    public DDLDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDL ddl, DDLRecordSetLocalService ddlRecordSetLocalService, DDLWebConfiguration ddlWebConfiguration, DDMDisplayRegistry ddmDisplayRegistry, DDMPermissionSupport ddmPermissionSupport, DDMTemplateLocalService ddmTemplateLocalService, StorageEngine storageEngine) throws PortalException {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddl = ddl;
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
        this._ddlWebConfiguration = ddlWebConfiguration;
        this._ddmDisplayRegistry = ddmDisplayRegistry;
        this._ddmPermissionSupport = ddmPermissionSupport;
        this._ddmTemplateLocalService = ddmTemplateLocalService;
        this._storageEngine = storageEngine;
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        this._ddlRequestHelper = new DDLRequestHelper(httpServletRequest);
        if (Validator.isNotNull((String)this.getPortletResource())) {
            return;
        }
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null || !this.hasViewPermission()) {
            renderRequest.setAttribute("PORTLET_CONFIGURATOR_VISIBILITY", (Object)Boolean.TRUE);
        }
    }

    public boolean changeableDefaultLanguage() {
        return this._ddlWebConfiguration.changeableDefaultLanguage();
    }

    public List<DropdownItem> getActionItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteRecordSets");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDLDisplayContext.this._ddlRequestHelper.getRequest(), (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getAddDDMTemplateTitle() throws PortalException {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getEditTemplateTitle(this._recordSet.getDDMStructure(), null, this.getLocale());
    }

    public String getAddRecordLabel() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        String structureName = "";
        if (recordSet != null) {
            DDMStructure ddmStructure = recordSet.getDDMStructure();
            structureName = ddmStructure.getName(this._ddlRequestHelper.getLocale());
        }
        return LanguageUtil.format((HttpServletRequest)this._ddlRequestHelper.getRequest(), (String)"add-x", (Object)HtmlUtil.escape((String)structureName), (boolean)false);
    }

    public String getClearResultsURL() throws PortletException {
        PortletURL clearResultsURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() {
        if (!this.isShowAddRecordSetIcon()) {
            return null;
        }
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(DDLDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_record_set.jsp", "redirect", PortalUtil.getCurrentURL((HttpServletRequest)DDLDisplayContext.this._ddlRequestHelper.getRequest())});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDLDisplayContext.this._ddlRequestHelper.getRequest(), (String)"add"));
                });
            }
        };
    }

    public String getCSVExport() {
        return this._ddlWebConfiguration.csvExport();
    }

    public OrderByComparator<DDLRecordSet> getDDLRecordSetOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        DDLRecordSetCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new DDLRecordSetCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new DDLRecordSetModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new DDLRecordSetNameComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public DDMFormValues getDDMFormValues(long classPK) throws PortalException {
        return this._storageEngine.getDDMFormValues(classPK);
    }

    public long getDisplayDDMTemplateId() {
        return PrefsParamUtil.getLong((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"displayDDMTemplateId");
    }

    public String getDisplayStyle() {
        if (this._ddlRecordDisplayStyle == null) {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._ddlRequestHelper.getRenderRequest());
            this._ddlRecordDisplayStyle = ParamUtil.getString((PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"displayStyle");
            if (Validator.isNull((String)this._ddlRecordDisplayStyle)) {
                this._ddlRecordDisplayStyle = portalPreferences.getValue("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "display-style", this._ddlWebConfiguration.defaultDisplayView());
            } else if (ArrayUtil.contains((Object[])this.getDisplayViews(), (Object)this._ddlRecordDisplayStyle)) {
                portalPreferences.setValue("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "display-style", this._ddlRecordDisplayStyle);
            }
            if (!ArrayUtil.contains((Object[])this.getDisplayViews(), (Object)this._ddlRecordDisplayStyle)) {
                this._ddlRecordDisplayStyle = this.getDisplayViews()[0];
            }
        }
        return this._ddlRecordDisplayStyle;
    }

    public String[] getDisplayViews() {
        return _DISPLAY_VIEWS;
    }

    public String getEditDisplayDDMTemplateTitle() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return "";
        }
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getEditTemplateTitle(recordSet.getDDMStructure(), this.fetchDisplayDDMTemplate(), this.getLocale());
    }

    public String getEditFormDDMTemplateTitle() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return LanguageUtil.get((Locale)this.getLocale(), (String)"add-list");
        }
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return ddmDisplay.getEditTemplateTitle(recordSet.getDDMStructure(), this.fetchFormDDMTemplate(), this.getLocale());
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        final HttpServletRequest httpServletRequest = this._ddlRequestHelper.getRequest();
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDLDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDLDisplayContext.this.getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public long getFormDDMTemplateId() {
        return PrefsParamUtil.getLong((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"formDDMTemplateId");
    }

    public List<NavigationItem> getNavigationItems() {
        final HttpServletRequest httpServletRequest = this._ddlRequestHelper.getRequest();
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(HtmlUtil.escape((String)LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"lists")));
                });
            }
        };
    }

    public String getOrderByCol() {
        return ParamUtil.getString((PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"orderByCol", (String)"modified-date");
    }

    public String getOrderByType() {
        return ParamUtil.getString((PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"orderByType", (String)"asc");
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        String delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(displayStyle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"displayStyle")))) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public DDLRecordSet getRecordSet() {
        if (this._recordSet != null) {
            return this._recordSet;
        }
        RenderRequest renderRequest = this._ddlRequestHelper.getRenderRequest();
        this._recordSet = (DDLRecordSet)renderRequest.getAttribute("DYNAMIC_DATA_LISTS_RECORD_SET");
        if (this._recordSet != null) {
            return this._recordSet;
        }
        this._recordSet = this._ddlRecordSetLocalService.fetchDDLRecordSet(this.getRecordSetId());
        return this._recordSet;
    }

    public long getRecordSetId() {
        return PrefsParamUtil.getLong((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"recordSetId");
    }

    public JSONArray getRecordSetJSONArray(DDLRecordSet recordSet, Locale locale) throws Exception {
        return this._ddl.getRecordSetJSONArray(recordSet, locale);
    }

    public JSONArray getRecordsJSONArray(List<DDLRecord> records, boolean latestRecordVersion, Locale locale) throws Exception {
        return this._ddl.getRecordsJSONArray(records, latestRecordVersion, locale);
    }

    public SearchContainer<?> getSearch() {
        String displayStyle = this.getDisplayStyle();
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("displayStyle", displayStyle);
        RecordSetSearch recordSetSearch = new RecordSetSearch((PortletRequest)this._renderRequest, portletURL);
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator<DDLRecordSet> orderByComparator = this.getDDLRecordSetOrderByComparator(orderByCol, orderByType);
        recordSetSearch.setOrderByCol(orderByCol);
        recordSetSearch.setOrderByComparator(orderByComparator);
        recordSetSearch.setOrderByType(orderByType);
        if (recordSetSearch.isSearch()) {
            recordSetSearch.setEmptyResultsMessage("no-lists-were-found");
        } else {
            recordSetSearch.setEmptyResultsMessage("there-are-no-lists");
        }
        this.setDDLRecordSetSearchResults(recordSetSearch);
        this.setDDLRecordSetSearchTotal(recordSetSearch);
        return recordSetSearch;
    }

    public String getSearchContainerId() {
        return "ddlRecordSet";
    }

    public String getSortingURL() throws Exception {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        sortingURL.setParameter("orderByType", orderByType.equals("asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() {
        SearchContainer<?> searchContainer = this.getSearch();
        return searchContainer.getTotal();
    }

    public List<ViewTypeItem> getViewTypesItems() throws Exception {
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                if (ArrayUtil.contains((Object[])DDLDisplayContext.this.getDisplayViews(), (Object)"descriptive")) {
                    this.addListViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])DDLDisplayContext.this.getDisplayViews(), (Object)"list")) {
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    public boolean isAdminPortlet() {
        String portletName = this.getPortletName();
        return portletName.equals("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet");
    }

    public boolean isDisabledManagementBar() {
        if (this.hasResults()) {
            return false;
        }
        return !this.isSearch();
    }

    public boolean isDisplayPortlet() {
        return !this.isAdminPortlet();
    }

    public boolean isEditable() {
        if (this.isAdminPortlet()) {
            return true;
        }
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"editable", (boolean)true);
    }

    public boolean isFormView() {
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"formView");
    }

    public boolean isShowAddDDMDisplayTemplateIcon() throws PortalException {
        return this.isShowAddDDMTemplateIcon() && !this.isFormView();
    }

    public boolean isShowAddDDMFormTemplateIcon() throws PortalException {
        return this.isShowAddDDMTemplateIcon();
    }

    public boolean isShowAddRecordButton() throws PortalException {
        if (this.isFormView() || this.isSpreadsheet()) {
            return false;
        }
        return this.isEditable() && this.hasAddRecordPermission();
    }

    public boolean isShowAddRecordSetIcon() {
        if (this._hasAddRecordSetPermission != null) {
            return this._hasAddRecordSetPermission;
        }
        this._hasAddRecordSetPermission = DDLPermission.contains(this.getPermissionChecker(), this.getScopeGroupId(), "ADD_RECORD_SET");
        return this._hasAddRecordSetPermission;
    }

    public boolean isShowCancelButton() {
        return !this.isFormView();
    }

    public boolean isShowConfigurationIcon() throws PortalException {
        if (this._showConfigurationIcon != null) {
            return this._showConfigurationIcon;
        }
        this._showConfigurationIcon = PortletPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Layout)this.getLayout(), (String)this.getPortletId(), (String)"CONFIGURATION");
        return this._showConfigurationIcon;
    }

    public boolean isShowEditDisplayDDMTemplateIcon() throws PortalException {
        if (this._hasEditDisplayDDMTemplatePermission != null) {
            return this._hasEditDisplayDDMTemplatePermission;
        }
        this._hasEditDisplayDDMTemplatePermission = Boolean.FALSE;
        DDMTemplate displayDDMTemplate = this.fetchDisplayDDMTemplate();
        if (displayDDMTemplate == null) {
            return this._hasEditDisplayDDMTemplatePermission;
        }
        this._hasEditDisplayDDMTemplatePermission = DDMTemplatePermission.contains(this.getPermissionChecker(), this.getDisplayDDMTemplateId(), "UPDATE");
        return this._hasEditDisplayDDMTemplatePermission;
    }

    public boolean isShowEditFormDDMTemplateIcon() throws PortalException {
        if (this._hasEditFormDDMTemplatePermission != null) {
            return this._hasEditFormDDMTemplatePermission;
        }
        this._hasEditFormDDMTemplatePermission = Boolean.FALSE;
        if (this.getFormDDMTemplateId() == 0L) {
            return this._hasEditFormDDMTemplatePermission;
        }
        this._hasEditFormDDMTemplatePermission = DDMTemplatePermission.contains(this.getPermissionChecker(), this.getFormDDMTemplateId(), "UPDATE");
        return this._hasEditFormDDMTemplatePermission;
    }

    public boolean isShowEditRecordSetIcon() throws PortalException {
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return false;
        }
        return DDLRecordSetPermission.contains(this.getPermissionChecker(), recordSet, "UPDATE");
    }

    public boolean isShowIconsActions() throws PortalException {
        if (this.isSpreadsheet()) {
            return false;
        }
        if (this._hasShowIconsActionPermission != null) {
            return this._hasShowIconsActionPermission;
        }
        this._hasShowIconsActionPermission = Boolean.FALSE;
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        if (!themeDisplay.isSignedIn()) {
            return this._hasShowIconsActionPermission;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout.isLayoutPrototypeLinkActive()) {
            return this._hasShowIconsActionPermission;
        }
        if (this.isShowConfigurationIcon() || this.isShowAddDDMDisplayTemplateIcon() || this.isShowAddDDMFormTemplateIcon() || this.isShowEditDisplayDDMTemplateIcon() || this.isShowEditFormDDMTemplateIcon()) {
            this._hasShowIconsActionPermission = Boolean.TRUE;
        }
        return this._hasShowIconsActionPermission;
    }

    public boolean isShowPublishRecordButton() throws PortalException {
        return this.isEditable() && this.hasAddRecordPermission();
    }

    public boolean isShowSaveRecordButton() throws PortalException {
        if (this.isFormView()) {
            return false;
        }
        return this.isEditable() && this.hasAddRecordPermission();
    }

    public boolean isSpreadsheet() {
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"spreadsheet");
    }

    protected DDMTemplate fetchDisplayDDMTemplate() {
        if (this._displayDDMTemplate != null) {
            return this._displayDDMTemplate;
        }
        this._displayDDMTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(this.getDisplayDDMTemplateId());
        return this._displayDDMTemplate;
    }

    protected DDMTemplate fetchFormDDMTemplate() {
        if (this._formDDMTemplate != null) {
            return this._formDDMTemplate;
        }
        this._formDDMTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(this.getFormDDMTemplateId());
        return this._formDDMTemplate;
    }

    protected DDMDisplay getDDMDisplay() {
        return this._ddmDisplayRegistry.getDDMDisplay("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet");
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(DDLDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDLDisplayContext.this._ddlRequestHelper.getRequest(), (String)"all"));
                });
            }
        };
    }

    protected String getKeywords() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
    }

    protected Layout getLayout() {
        return this._ddlRequestHelper.getLayout();
    }

    protected Locale getLocale() {
        return this._ddlRequestHelper.getLocale();
    }

    protected UnsafeConsumer<DropdownItem, Exception> getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(orderByCol.equals(this.getOrderByCol()));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._ddlRequestHelper.getRequest(), (String)orderByCol));
        };
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(DDLDisplayContext.this.getOrderByDropdownItem("create-date"));
                this.add(DDLDisplayContext.this.getOrderByDropdownItem("modified-date"));
                this.add(DDLDisplayContext.this.getOrderByDropdownItem("name"));
            }
        };
    }

    protected PermissionChecker getPermissionChecker() {
        return this._ddlRequestHelper.getPermissionChecker();
    }

    protected String getPortletId() {
        return this._ddlRequestHelper.getPortletId();
    }

    protected String getPortletName() {
        return this._ddlRequestHelper.getPortletName();
    }

    protected String getPortletResource() {
        return this._ddlRequestHelper.getPortletResource();
    }

    protected long getScopeGroupId() {
        return this._ddlRequestHelper.getScopeGroupId();
    }

    protected long getStructureTypeClassNameId() {
        DDMDisplay ddmDisplay = this.getDDMDisplay();
        return PortalUtil.getClassNameId((String)ddmDisplay.getStructureType());
    }

    protected ThemeDisplay getThemeDisplay() {
        return this._ddlRequestHelper.getThemeDisplay();
    }

    protected boolean hasAddRecordPermission() throws PortalException {
        if (this._hasAddRecordPermission != null) {
            return this._hasAddRecordPermission;
        }
        this._hasAddRecordPermission = false;
        if (this._recordSet != null) {
            this._hasAddRecordPermission = DDLRecordSetPermission.contains(this.getPermissionChecker(), this._recordSet, "ADD_RECORD");
        }
        return this._hasAddRecordPermission;
    }

    protected boolean hasResults() {
        return this.getTotalItems() > 0;
    }

    protected boolean hasViewPermission() throws PortalException {
        if (this._hasViewPermission != null) {
            return this._hasViewPermission;
        }
        this._hasViewPermission = true;
        if (this._recordSet != null) {
            this._hasViewPermission = DDLRecordSetPermission.contains(this.getPermissionChecker(), this._recordSet, "VIEW");
        }
        return this._hasViewPermission;
    }

    protected boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    protected boolean isShowAddDDMTemplateIcon() throws PortalException {
        if (this._hasAddDDMTemplatePermission != null) {
            return this._hasAddDDMTemplatePermission;
        }
        this._hasAddDDMTemplatePermission = Boolean.FALSE;
        DDLRecordSet recordSet = this.getRecordSet();
        if (recordSet == null) {
            return this._hasAddDDMTemplatePermission;
        }
        this._hasAddDDMTemplatePermission = this._ddmPermissionSupport.containsAddTemplatePermission(this.getPermissionChecker(), this.getScopeGroupId(), this.getStructureTypeClassNameId(), this.getStructureTypeClassNameId());
        return this._hasAddDDMTemplatePermission;
    }

    protected void setDDLRecordSetSearchResults(RecordSetSearch recordSetSearch) {
        List results = this._ddlRecordSetLocalService.search(this._ddlRequestHelper.getCompanyId(), this._ddlRequestHelper.getScopeGroupId(), this.getKeywords(), 0, recordSetSearch.getStart(), recordSetSearch.getEnd(), recordSetSearch.getOrderByComparator());
        recordSetSearch.setResults(results);
    }

    protected void setDDLRecordSetSearchTotal(RecordSetSearch recordSetSearch) {
        int total = this._ddlRecordSetLocalService.searchCount(this._ddlRequestHelper.getCompanyId(), this._ddlRequestHelper.getScopeGroupId(), this.getKeywords(), 0);
        recordSetSearch.setTotal(total);
    }
}

