/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.asset.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.dynamic.data.lists.web.internal.asset.model.DDLRecordAssetRenderer;
import com.liferay.dynamic.data.lists.web.internal.asset.model.DDLRecordSetClassTypeReader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLPortlet"}, service={AssetRendererFactory.class})
public class DDLRecordAssetRendererFactory
extends BaseAssetRendererFactory<DDLRecord> {
    public static final String TYPE = "record";
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet)")
    private ModelResourcePermission<DDLRecordSet> _ddlRecordSetModelResourcePermission;
    private DDLRecordVersionLocalService _ddlRecordVersionLocalService;
    @Reference
    private Portal _portal;
    private ServletContext _servletContext;

    public DDLRecordAssetRendererFactory() {
        this.setCategorizable(false);
        this.setClassName(DDLRecord.class.getName());
        this.setPortletId("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet");
        this.setSearchable(true);
        this.setSelectable(true);
    }

    public AssetRenderer<DDLRecord> getAssetRenderer(long classPK, int type) throws PortalException {
        DDLRecord record = this._ddlRecordLocalService.fetchDDLRecord(classPK);
        DDLRecordVersion recordVersion = null;
        if (record == null) {
            recordVersion = this._ddlRecordVersionLocalService.getRecordVersion(classPK);
            record = recordVersion.getRecord();
        } else if (type == 0) {
            recordVersion = record.getLatestRecordVersion();
        } else if (type == 1) {
            recordVersion = record.getRecordVersion();
        } else {
            throw new IllegalArgumentException("Unknown asset renderer type " + type);
        }
        DDLRecordAssetRenderer ddlRecordAssetRenderer = new DDLRecordAssetRenderer(record, recordVersion);
        ddlRecordAssetRenderer.setAssetRendererType(type);
        ddlRecordAssetRenderer.setServletContext(this._servletContext);
        return ddlRecordAssetRenderer;
    }

    public String getClassName() {
        return DDLRecord.class.getName();
    }

    public ClassTypeReader getClassTypeReader() {
        return new DDLRecordSetClassTypeReader();
    }

    public String getIconCssClass() {
        return "dynamic-data-list";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, this.getGroup(liferayPortletRequest), "com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", 0L, 0L, "RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_record.jsp");
        if (classTypeId > 0L) {
            portletURL.setParameter("recordSetId", String.valueOf(classTypeId));
        }
        return portletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        if (classTypeId == 0L) {
            return false;
        }
        return this._ddlRecordSetModelResourcePermission.contains(permissionChecker, classTypeId, "ADD_RECORD");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        DDLRecord record = this._ddlRecordLocalService.getDDLRecord(classPK);
        return this._ddlRecordSetModelResourcePermission.contains(permissionChecker, record.getRecordSetId(), actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.dynamic.data.lists.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordVersionLocalService(DDLRecordVersionLocalService ddlRecordVersionLocalService) {
        this._ddlRecordVersionLocalService = ddlRecordVersionLocalService;
    }
}

