/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletId;
import com.liferay.portal.kernel.util.StringUtil;

public class UpgradeDDLFormPortletId
extends BaseUpgradePortletId {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDDLFormPortletId.class);
    private final PortletPreferencesLocalService _portletPreferencesLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public UpgradeDDLFormPortletId(PortletPreferencesLocalService portletPreferencesLocalService, ResourcePermissionLocalService resourcePermissionLocalService) {
        this._portletPreferencesLocalService = portletPreferencesLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    protected void deleteResourcePermissions(final String oldRootPortletId, final String newRootPortletId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property nameProperty = PropertyFactoryUtil.forName((String)"name");
                dynamicQuery.add(nameProperty.eq((Object)new String(oldRootPortletId)));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourcePermission>(){

            public void performAction(ResourcePermission resourcePermission) throws PortalException {
                long total = UpgradeDDLFormPortletId.this.getResourcePermissionsCount(resourcePermission.getCompanyId(), newRootPortletId, resourcePermission.getScope(), resourcePermission.getRoleId());
                if (total > 0L) {
                    UpgradeDDLFormPortletId.this._resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
                }
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[][]{{"1_WAR_ddlformportlet", "com_liferay_dynamic_data_lists_web_portlet_DDLDisplayPortlet"}};
    }

    protected long getResourcePermissionsCount(final long companyId, final String name, final int scope, final long roleId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
                dynamicQuery.add(companyIdProperty.eq((Object)companyId));
                Property nameProperty = PropertyFactoryUtil.forName((String)"name");
                dynamicQuery.add(nameProperty.eq((Object)name));
                Property scopeProperty = PropertyFactoryUtil.forName((String)"scope");
                dynamicQuery.add(scopeProperty.eq((Object)scope));
                Property roleIdProperty = PropertyFactoryUtil.forName((String)"roleId");
                dynamicQuery.add(roleIdProperty.eq((Object)roleId));
            }
        });
        return actionableDynamicQuery.performCount();
    }

    protected void updateInstanceablePortletPreferences(final String oldRootPortletId, final String newRootPortletId) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._portletPreferencesLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction junction = RestrictionsFactoryUtil.disjunction();
                Property property = PropertyFactoryUtil.forName((String)"portletId");
                junction.add(property.eq((Object)oldRootPortletId));
                junction.add(property.like((Object)(oldRootPortletId + "_INSTANCE_%")));
                junction.add(property.like((Object)(oldRootPortletId + "_USER_%_INSTANCE_%")));
                dynamicQuery.add((Criterion)junction);
            }
        });
        actionableDynamicQuery.setParallel(true);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<PortletPreferences>(){

            public void performAction(PortletPreferences portletPreference) throws PortalException {
                UpgradeDDLFormPortletId.this.updatePortletPreferences(portletPreference, oldRootPortletId, newRootPortletId);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        block2: {
            try {
                this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
                this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
                this.updateLayouts(oldRootPortletId, newRootPortletId, false);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected void updatePortletPreferences(PortletPreferences portletPreferences, String oldRootPortletId, String newRootPortletId) {
        String newPortletId = StringUtil.replace((String)portletPreferences.getPortletId(), (String)oldRootPortletId, (String)newRootPortletId);
        portletPreferences.setPortletId(newPortletId);
        String newPreferences = StringUtil.replace((String)portletPreferences.getPreferences(), (String)"</portlet-preferences>", (String)"<preference><name>formView</name><value>true</value></preference></portlet-preferences>");
        portletPreferences.setPreferences(newPreferences);
        this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
    }

    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        this.deleteResourcePermissions(oldRootPortletId, newRootPortletId);
        super.updateResourcePermission(oldRootPortletId, newRootPortletId, updateName);
    }
}

