/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.exception.NoSuchRecordVersionException;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordVersionVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordVersion"}, service={AopService.class})
public class DDLRecordVersionLocalServiceImpl
extends DDLRecordVersionLocalServiceBaseImpl {
    public DDLRecordVersion fetchLatestRecordVersion(long userId, long recordSetId, String recordSetVersion, int status) {
        return this.ddlRecordVersionPersistence.fetchByU_R_R_S_Last(userId, recordSetId, recordSetVersion, status, null);
    }

    public DDLRecordVersion getLatestRecordVersion(long recordId) throws PortalException {
        List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(recordId);
        if (recordVersions.isEmpty()) {
            throw new NoSuchRecordVersionException("No record versions found for record ID " + recordId);
        }
        recordVersions = ListUtil.copy((List)recordVersions);
        Collections.sort(recordVersions, new DDLRecordVersionVersionComparator());
        return (DDLRecordVersion)recordVersions.get(0);
    }

    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException {
        return this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
    }

    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException {
        return this.ddlRecordVersionPersistence.findByR_V(recordId, version);
    }

    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) {
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    public int getRecordVersionsCount(long recordId) {
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }
}

