/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordSetNameComparator;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet"}, service={DDLRecordSetStagedModelRepository.class, StagedModelRepository.class})
public class DDLRecordSetStagedModelRepository
implements StagedModelRepository<DDLRecordSet> {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    public DDLRecordSet addStagedModel(PortletDataContext portletDataContext, DDLRecordSet ddlRecordSet) throws PortalException {
        long userId = portletDataContext.getUserId(ddlRecordSet.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddlRecordSet);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddlRecordSet.getUuid());
        } else {
            ddlRecordSet.setRecordSetKey(null);
        }
        return this._ddlRecordSetLocalService.addRecordSet(userId, ddlRecordSet.getGroupId(), ddlRecordSet.getDDMStructureId(), ddlRecordSet.getRecordSetKey(), ddlRecordSet.getNameMap(), ddlRecordSet.getDescriptionMap(), ddlRecordSet.getMinDisplayRows(), ddlRecordSet.getScope(), serviceContext);
    }

    public void deleteStagedModel(DDLRecordSet ddlRecordSet) throws PortalException {
        this._ddlRecordSetLocalService.deleteRecordSet(ddlRecordSet);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDLRecordSet ddlRecordSet = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddlRecordSet != null) {
            this.deleteStagedModel(ddlRecordSet);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this.deleteStagedModels(portletDataContext, 0);
    }

    public void deleteStagedModels(PortletDataContext portletDataContext, int scope) throws PortalException {
        HashSet<Long> recordSetDDMStructureIds = new HashSet<Long>();
        List recordSets = this._ddlRecordSetLocalService.search(portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), null, scope, -1, -1, (OrderByComparator)new DDLRecordSetNameComparator());
        for (DDLRecordSet recordSet : recordSets) {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(recordSet.getDDMStructureId());
            if (ddmStructure.getGroupId() == recordSet.getGroupId()) {
                recordSetDDMStructureIds.add(recordSet.getDDMStructureId());
            }
            this._ddlRecordSetLocalService.deleteRecordSet(recordSet);
        }
        this.deleteDDMStructures(recordSetDDMStructureIds);
    }

    public DDLRecordSet fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddlRecordSetLocalService.fetchDDLRecordSetByUuidAndGroupId(uuid, groupId);
    }

    public List<DDLRecordSet> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddlRecordSetLocalService.getDDLRecordSetsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this.getExportActionableDynamicQuery(portletDataContext, 0);
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext, int scope) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddlRecordSetLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property scopeProperty = PropertyFactoryUtil.forName((String)"scope");
            dynamicQuery.add(scopeProperty.eq((Object)scope));
        });
        exportActionableDynamicQuery.setPerformActionMethod(ddlRecordSet -> {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddlRecordSet);
            DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmStructure);
            if (scope == 0) {
                for (DDMTemplate ddmTemplate : ddmStructure.getTemplates()) {
                    StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmTemplate);
                }
            }
        });
        return exportActionableDynamicQuery;
    }

    public DDLRecordSet getStagedModel(long recordSetId) throws PortalException {
        return this._ddlRecordSetLocalService.getDDLRecordSet(recordSetId);
    }

    public DDLRecordSet saveStagedModel(DDLRecordSet ddlRecordSet) throws PortalException {
        return this._ddlRecordSetLocalService.updateDDLRecordSet(ddlRecordSet);
    }

    public DDLRecordSet updateStagedModel(PortletDataContext portletDataContext, DDLRecordSet ddlRecordSet) throws PortalException {
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddlRecordSet);
        return this._ddlRecordSetLocalService.updateRecordSet(ddlRecordSet.getRecordSetId(), ddlRecordSet.getDDMStructureId(), ddlRecordSet.getNameMap(), ddlRecordSet.getDescriptionMap(), ddlRecordSet.getMinDisplayRows(), serviceContext);
    }

    protected void deleteDDMStructures(Set<Long> ddmStructureIds) throws PortalException {
        for (Long ddmStructureId : ddmStructureIds) {
            this._ddmStructureLocalService.deleteStructure(ddmStructureId.longValue());
        }
    }
}

