/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.lists.constants;

/**
 * Holds action key constants used in the DDL permission system.
 *
 * @author Rafael Praxedes
 */
public class DDLActionKeys {

	/**
	 * {@value #ADD_RECORD} is the action key to use to check permissions for
	 * adding a record.
	 */
	public static final String ADD_RECORD = "ADD_RECORD";

	/**
	 * {@value #ADD_RECORD_SET} is the action key to use to check permissions
	 * for adding record sets.
	 */
	public static final String ADD_RECORD_SET = "ADD_RECORD_SET";

}