'use strict';

Liferay.Loader.define('document-library-web$loose-envify@1.4.0/loose-envify', ['module', 'exports', 'require', 'document-library-web$stream', 'frontend-js-node-shims$util', './replace'], function (module, exports, require) {
  var define = undefined;
  var stream = require('document-library-web$stream');
  var util = require('frontend-js-node-shims$util');
  var replace = require('./replace');

  var jsonExtRe = /\.json$/;

  module.exports = function (rootEnv) {
    rootEnv = rootEnv || process.env;
    return function (file, trOpts) {
      if (jsonExtRe.test(file)) {
        return stream.PassThrough();
      }
      var envs = trOpts ? [rootEnv, trOpts] : [rootEnv];
      return new LooseEnvify(envs);
    };
  };

  function LooseEnvify(envs) {
    stream.Transform.call(this);
    this._data = '';
    this._envs = envs;
  }
  util.inherits(LooseEnvify, stream.Transform);

  LooseEnvify.prototype._transform = function (buf, enc, cb) {
    this._data += buf;
    cb();
  };

  LooseEnvify.prototype._flush = function (cb) {
    var replaced = replace(this._data, this._envs);
    this.push(replaced);
    cb();
  };
});
//# sourceMappingURL=loose-envify.js.map